package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  CustomKeyStoreNameType,
  CloudHsmClusterIdType,
  XksProxyVpcEndpointServiceNameType,
  CustomKeyStoreIdType,
  XksProxyUriPathType,
  KeyStorePasswordType,
  XksProxyUriEndpointType
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCustomKeyStoreRequest(
    customKeyStoreId: CustomKeyStoreIdType,
    newCustomKeyStoreName: Optional[CustomKeyStoreNameType] = Optional.Absent,
    keyStorePassword: Optional[KeyStorePasswordType] = Optional.Absent,
    cloudHsmClusterId: Optional[CloudHsmClusterIdType] = Optional.Absent,
    xksProxyUriEndpoint: Optional[XksProxyUriEndpointType] = Optional.Absent,
    xksProxyUriPath: Optional[XksProxyUriPathType] = Optional.Absent,
    xksProxyVpcEndpointServiceName: Optional[
      XksProxyVpcEndpointServiceNameType
    ] = Optional.Absent,
    xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType
    ] = Optional.Absent,
    xksProxyConnectivity: Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest = {
    import UpdateCustomKeyStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
      .builder()
      .customKeyStoreId(
        CustomKeyStoreIdType.unwrap(customKeyStoreId): java.lang.String
      )
      .optionallyWith(
        newCustomKeyStoreName.map(value =>
          CustomKeyStoreNameType.unwrap(value): java.lang.String
        )
      )(_.newCustomKeyStoreName)
      .optionallyWith(
        keyStorePassword.map(value =>
          KeyStorePasswordType.unwrap(value): java.lang.String
        )
      )(_.keyStorePassword)
      .optionallyWith(
        cloudHsmClusterId.map(value =>
          CloudHsmClusterIdType.unwrap(value): java.lang.String
        )
      )(_.cloudHsmClusterId)
      .optionallyWith(
        xksProxyUriEndpoint.map(value =>
          XksProxyUriEndpointType.unwrap(value): java.lang.String
        )
      )(_.xksProxyUriEndpoint)
      .optionallyWith(
        xksProxyUriPath.map(value =>
          XksProxyUriPathType.unwrap(value): java.lang.String
        )
      )(_.xksProxyUriPath)
      .optionallyWith(
        xksProxyVpcEndpointServiceName.map(value =>
          XksProxyVpcEndpointServiceNameType.unwrap(value): java.lang.String
        )
      )(_.xksProxyVpcEndpointServiceName)
      .optionallyWith(
        xksProxyAuthenticationCredential.map(value => value.buildAwsValue())
      )(_.xksProxyAuthenticationCredential)
      .optionallyWith(xksProxyConnectivity.map(value => value.unwrap))(
        _.xksProxyConnectivity
      )
      .build()
  }
  def asReadOnly: zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly =
    zio.aws.kms.model.UpdateCustomKeyStoreRequest.wrap(buildAwsValue())
}
object UpdateCustomKeyStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.UpdateCustomKeyStoreRequest =
      zio.aws.kms.model.UpdateCustomKeyStoreRequest(
        customKeyStoreId,
        newCustomKeyStoreName.map(value => value),
        keyStorePassword.map(value => value),
        cloudHsmClusterId.map(value => value),
        xksProxyUriEndpoint.map(value => value),
        xksProxyUriPath.map(value => value),
        xksProxyVpcEndpointServiceName.map(value => value),
        xksProxyAuthenticationCredential.map(value => value.asEditable),
        xksProxyConnectivity.map(value => value)
      )
    def customKeyStoreId: CustomKeyStoreIdType
    def newCustomKeyStoreName: Optional[CustomKeyStoreNameType]
    def keyStorePassword: Optional[KeyStorePasswordType]
    def cloudHsmClusterId: Optional[CloudHsmClusterIdType]
    def xksProxyUriEndpoint: Optional[XksProxyUriEndpointType]
    def xksProxyUriPath: Optional[XksProxyUriPathType]
    def xksProxyVpcEndpointServiceName
        : Optional[XksProxyVpcEndpointServiceNameType]
    def xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ]
    def xksProxyConnectivity
        : Optional[zio.aws.kms.model.XksProxyConnectivityType]
    def getCustomKeyStoreId: ZIO[Any, Nothing, CustomKeyStoreIdType] =
      ZIO.succeed(customKeyStoreId)
    def getNewCustomKeyStoreName: ZIO[Any, AwsError, CustomKeyStoreNameType] =
      AwsError.unwrapOptionField("newCustomKeyStoreName", newCustomKeyStoreName)
    def getKeyStorePassword: ZIO[Any, AwsError, KeyStorePasswordType] =
      AwsError.unwrapOptionField("keyStorePassword", keyStorePassword)
    def getCloudHsmClusterId: ZIO[Any, AwsError, CloudHsmClusterIdType] =
      AwsError.unwrapOptionField("cloudHsmClusterId", cloudHsmClusterId)
    def getXksProxyUriEndpoint: ZIO[Any, AwsError, XksProxyUriEndpointType] =
      AwsError.unwrapOptionField("xksProxyUriEndpoint", xksProxyUriEndpoint)
    def getXksProxyUriPath: ZIO[Any, AwsError, XksProxyUriPathType] =
      AwsError.unwrapOptionField("xksProxyUriPath", xksProxyUriPath)
    def getXksProxyVpcEndpointServiceName
        : ZIO[Any, AwsError, XksProxyVpcEndpointServiceNameType] =
      AwsError.unwrapOptionField(
        "xksProxyVpcEndpointServiceName",
        xksProxyVpcEndpointServiceName
      )
    def getXksProxyAuthenticationCredential: ZIO[
      Any,
      AwsError,
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "xksProxyAuthenticationCredential",
      xksProxyAuthenticationCredential
    )
    def getXksProxyConnectivity
        : ZIO[Any, AwsError, zio.aws.kms.model.XksProxyConnectivityType] =
      AwsError.unwrapOptionField("xksProxyConnectivity", xksProxyConnectivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ) extends zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly {
    override val customKeyStoreId: CustomKeyStoreIdType =
      zio.aws.kms.model.primitives.CustomKeyStoreIdType(impl.customKeyStoreId())
    override val newCustomKeyStoreName: Optional[CustomKeyStoreNameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newCustomKeyStoreName())
        .map(value =>
          zio.aws.kms.model.primitives.CustomKeyStoreNameType(value)
        )
    override val keyStorePassword: Optional[KeyStorePasswordType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStorePassword())
        .map(value => zio.aws.kms.model.primitives.KeyStorePasswordType(value))
    override val cloudHsmClusterId: Optional[CloudHsmClusterIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudHsmClusterId())
        .map(value => zio.aws.kms.model.primitives.CloudHsmClusterIdType(value))
    override val xksProxyUriEndpoint: Optional[XksProxyUriEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyUriEndpoint())
        .map(value =>
          zio.aws.kms.model.primitives.XksProxyUriEndpointType(value)
        )
    override val xksProxyUriPath: Optional[XksProxyUriPathType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyUriPath())
        .map(value => zio.aws.kms.model.primitives.XksProxyUriPathType(value))
    override val xksProxyVpcEndpointServiceName
        : Optional[XksProxyVpcEndpointServiceNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.xksProxyVpcEndpointServiceName())
      .map(value =>
        zio.aws.kms.model.primitives.XksProxyVpcEndpointServiceNameType(value)
      )
    override val xksProxyAuthenticationCredential: Optional[
      zio.aws.kms.model.XksProxyAuthenticationCredentialType.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.xksProxyAuthenticationCredential())
      .map(value =>
        zio.aws.kms.model.XksProxyAuthenticationCredentialType.wrap(value)
      )
    override val xksProxyConnectivity
        : Optional[zio.aws.kms.model.XksProxyConnectivityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xksProxyConnectivity())
        .map(value => zio.aws.kms.model.XksProxyConnectivityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest
  ): zio.aws.kms.model.UpdateCustomKeyStoreRequest.ReadOnly = new Wrapper(impl)
}
