package zio.aws.kms
import zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.kms.model.primitives.PolicyNameType
import zio.aws.kms.model.{
  GetParametersForImportRequest,
  ConnectCustomKeyStoreRequest,
  ListRetirableGrantsRequest,
  RetireGrantRequest,
  ListKeyPoliciesRequest,
  DisconnectCustomKeyStoreRequest,
  UpdateCustomKeyStoreRequest,
  UpdateAliasRequest,
  DeleteImportedKeyMaterialRequest,
  PutKeyPolicyRequest,
  EnableKeyRequest,
  GenerateDataKeyRequest,
  RevokeGrantRequest,
  CreateKeyRequest,
  CreateAliasRequest,
  ListGrantsRequest,
  EncryptRequest,
  GenerateMacRequest,
  DeleteCustomKeyStoreRequest,
  UpdateKeyDescriptionRequest,
  DeleteAliasRequest,
  ListAliasesRequest,
  DisableKeyRotationRequest,
  GenerateRandomRequest,
  GenerateDataKeyWithoutPlaintextRequest,
  GetKeyRotationStatusRequest,
  DescribeKeyRequest,
  EnableKeyRotationRequest,
  CreateGrantRequest,
  ReEncryptRequest,
  VerifyMacRequest,
  ListResourceTagsRequest,
  SignRequest,
  DescribeCustomKeyStoresRequest,
  VerifyRequest,
  CreateCustomKeyStoreRequest,
  UntagResourceRequest,
  UpdatePrimaryRegionRequest,
  DisableKeyRequest,
  ScheduleKeyDeletionRequest,
  DecryptRequest,
  GenerateDataKeyPairWithoutPlaintextRequest,
  GenerateDataKeyPairRequest,
  ListKeysRequest,
  GetPublicKeyRequest,
  CancelKeyDeletionRequest,
  ImportKeyMaterialRequest,
  TagResourceRequest,
  GetKeyPolicyRequest,
  ReplicateKeyRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.kms.paginators.{
  ListRetirableGrantsPublisher,
  ListKeyPoliciesPublisher,
  DescribeCustomKeyStoresPublisher,
  ListResourceTagsPublisher,
  ListAliasesPublisher,
  ListKeysPublisher,
  ListGrantsPublisher
}
import software.amazon.awssdk.services.kms.model.{
  KeyListEntry,
  UpdateAliasResponse,
  ListGrantsResponse,
  ListKeysResponse,
  DescribeCustomKeyStoresResponse,
  CreateCustomKeyStoreResponse,
  UpdateCustomKeyStoreResponse,
  ConnectCustomKeyStoreResponse,
  ImportKeyMaterialResponse,
  GenerateDataKeyPairWithoutPlaintextResponse,
  RetireGrantResponse,
  ListRetirableGrantsResponse,
  EnableKeyRotationResponse,
  DeleteAliasResponse,
  ListKeyPoliciesResponse,
  PutKeyPolicyResponse,
  GenerateDataKeyPairResponse,
  EncryptResponse,
  Tag,
  EnableKeyResponse,
  GenerateMacResponse,
  DisconnectCustomKeyStoreResponse,
  GenerateDataKeyWithoutPlaintextResponse,
  CreateAliasResponse,
  UpdateKeyDescriptionResponse,
  GenerateRandomResponse,
  GetKeyRotationStatusResponse,
  UntagResourceResponse,
  GrantListEntry,
  GenerateDataKeyResponse,
  DescribeKeyResponse,
  UpdatePrimaryRegionResponse,
  GetParametersForImportResponse,
  ReEncryptResponse,
  VerifyResponse,
  DeleteImportedKeyMaterialResponse,
  ScheduleKeyDeletionResponse,
  ListResourceTagsResponse,
  GetPublicKeyResponse,
  CreateGrantResponse,
  ReplicateKeyResponse,
  DisableKeyRotationResponse,
  VerifyMacResponse,
  CreateKeyResponse,
  SignResponse,
  CustomKeyStoresListEntry,
  ListAliasesResponse,
  CancelKeyDeletionResponse,
  RevokeGrantResponse,
  AliasListEntry,
  GetKeyPolicyResponse,
  TagResourceResponse,
  DecryptResponse,
  DisableKeyResponse,
  DeleteCustomKeyStoreResponse
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.kms.{
  KmsAsyncClientBuilder,
  KmsAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Kms extends AspectSupport[Kms] {
  val api: KmsAsyncClient
  def deleteImportedKeyMaterial(
      request: DeleteImportedKeyMaterialRequest
  ): IO[AwsError, Unit]
  def putKeyPolicy(request: PutKeyPolicyRequest): IO[AwsError, Unit]
  def describeCustomKeyStores(
      request: DescribeCustomKeyStoresRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly]
  def describeCustomKeyStoresPaginated(
      request: DescribeCustomKeyStoresRequest
  ): IO[AwsError, zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly]
  def importKeyMaterial(
      request: ImportKeyMaterialRequest
  ): IO[AwsError, zio.aws.kms.model.ImportKeyMaterialResponse.ReadOnly]
  def generateDataKeyWithoutPlaintext(
      request: GenerateDataKeyWithoutPlaintextRequest
  ): IO[AwsError, ReadOnly]
  def scheduleKeyDeletion(
      request: ScheduleKeyDeletionRequest
  ): IO[AwsError, zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly]
  def listRetirableGrants(
      request: ListRetirableGrantsRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.GrantListEntry.ReadOnly]
  def listRetirableGrantsPaginated(
      request: ListRetirableGrantsRequest
  ): IO[AwsError, zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly]
  def generateMac(
      request: GenerateMacRequest
  ): IO[AwsError, zio.aws.kms.model.GenerateMacResponse.ReadOnly]
  def deleteCustomKeyStore(
      request: DeleteCustomKeyStoreRequest
  ): IO[AwsError, zio.aws.kms.model.DeleteCustomKeyStoreResponse.ReadOnly]
  def replicateKey(
      request: ReplicateKeyRequest
  ): IO[AwsError, zio.aws.kms.model.ReplicateKeyResponse.ReadOnly]
  def revokeGrant(request: RevokeGrantRequest): IO[AwsError, Unit]
  def enableKeyRotation(request: EnableKeyRotationRequest): IO[AwsError, Unit]
  def createGrant(
      request: CreateGrantRequest
  ): IO[AwsError, zio.aws.kms.model.CreateGrantResponse.ReadOnly]
  def cancelKeyDeletion(
      request: CancelKeyDeletionRequest
  ): IO[AwsError, zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly]
  def decrypt(
      request: DecryptRequest
  ): IO[AwsError, zio.aws.kms.model.DecryptResponse.ReadOnly]
  def generateDataKeyPair(
      request: GenerateDataKeyPairRequest
  ): IO[AwsError, zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly]
  def verify(
      request: VerifyRequest
  ): IO[AwsError, zio.aws.kms.model.VerifyResponse.ReadOnly]
  def connectCustomKeyStore(
      request: ConnectCustomKeyStoreRequest
  ): IO[AwsError, zio.aws.kms.model.ConnectCustomKeyStoreResponse.ReadOnly]
  def sign(
      request: SignRequest
  ): IO[AwsError, zio.aws.kms.model.SignResponse.ReadOnly]
  def getPublicKey(
      request: GetPublicKeyRequest
  ): IO[AwsError, zio.aws.kms.model.GetPublicKeyResponse.ReadOnly]
  def updateKeyDescription(
      request: UpdateKeyDescriptionRequest
  ): IO[AwsError, Unit]
  def reEncrypt(
      request: ReEncryptRequest
  ): IO[AwsError, zio.aws.kms.model.ReEncryptResponse.ReadOnly]
  def generateDataKeyPairWithoutPlaintext(
      request: GenerateDataKeyPairWithoutPlaintextRequest
  ): IO[
    AwsError,
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly
  ]
  def getKeyRotationStatus(
      request: GetKeyRotationStatusRequest
  ): IO[AwsError, zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly]
  def listAliases(
      request: ListAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.AliasListEntry.ReadOnly]
  def listAliasesPaginated(
      request: ListAliasesRequest
  ): IO[AwsError, zio.aws.kms.model.ListAliasesResponse.ReadOnly]
  def getParametersForImport(
      request: GetParametersForImportRequest
  ): IO[AwsError, zio.aws.kms.model.GetParametersForImportResponse.ReadOnly]
  def verifyMac(
      request: VerifyMacRequest
  ): IO[AwsError, zio.aws.kms.model.VerifyMacResponse.ReadOnly]
  def encrypt(
      request: EncryptRequest
  ): IO[AwsError, zio.aws.kms.model.EncryptResponse.ReadOnly]
  def updateAlias(request: UpdateAliasRequest): IO[AwsError, Unit]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def createAlias(request: CreateAliasRequest): IO[AwsError, Unit]
  def disconnectCustomKeyStore(
      request: DisconnectCustomKeyStoreRequest
  ): IO[AwsError, zio.aws.kms.model.DisconnectCustomKeyStoreResponse.ReadOnly]
  def disableKey(request: DisableKeyRequest): IO[AwsError, Unit]
  def generateRandom(
      request: GenerateRandomRequest
  ): IO[AwsError, zio.aws.kms.model.GenerateRandomResponse.ReadOnly]
  def listGrants(
      request: ListGrantsRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.GrantListEntry.ReadOnly]
  def listGrantsPaginated(
      request: ListGrantsRequest
  ): IO[AwsError, zio.aws.kms.model.ListGrantsResponse.ReadOnly]
  def updatePrimaryRegion(
      request: UpdatePrimaryRegionRequest
  ): IO[AwsError, Unit]
  def createKey(
      request: CreateKeyRequest
  ): IO[AwsError, zio.aws.kms.model.CreateKeyResponse.ReadOnly]
  def enableKey(request: EnableKeyRequest): IO[AwsError, Unit]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit]
  def getKeyPolicy(
      request: GetKeyPolicyRequest
  ): IO[AwsError, zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly]
  def listKeyPolicies(
      request: ListKeyPoliciesRequest
  ): ZStream[Any, AwsError, PolicyNameType]
  def listKeyPoliciesPaginated(
      request: ListKeyPoliciesRequest
  ): IO[AwsError, zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly]
  def disableKeyRotation(request: DisableKeyRotationRequest): IO[AwsError, Unit]
  def generateDataKey(
      request: GenerateDataKeyRequest
  ): IO[AwsError, zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly]
  def updateCustomKeyStore(
      request: UpdateCustomKeyStoreRequest
  ): IO[AwsError, zio.aws.kms.model.UpdateCustomKeyStoreResponse.ReadOnly]
  def retireGrant(request: RetireGrantRequest): IO[AwsError, Unit]
  def createCustomKeyStore(
      request: CreateCustomKeyStoreRequest
  ): IO[AwsError, zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly]
  def listResourceTags(
      request: ListResourceTagsRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.Tag.ReadOnly]
  def listResourceTagsPaginated(
      request: ListResourceTagsRequest
  ): IO[AwsError, zio.aws.kms.model.ListResourceTagsResponse.ReadOnly]
  def describeKey(
      request: DescribeKeyRequest
  ): IO[AwsError, zio.aws.kms.model.DescribeKeyResponse.ReadOnly]
  def listKeys(
      request: ListKeysRequest
  ): ZStream[Any, AwsError, zio.aws.kms.model.KeyListEntry.ReadOnly]
  def listKeysPaginated(
      request: ListKeysRequest
  ): IO[AwsError, zio.aws.kms.model.ListKeysResponse.ReadOnly]
}
object Kms {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Kms] = customized(identity)
  def customized(
      customization: KmsAsyncClientBuilder => KmsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Kms] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KmsAsyncClientBuilder => KmsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Kms] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KmsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[KmsAsyncClient, KmsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[KmsAsyncClient, KmsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new KmsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class KmsImpl[R](
      override val api: KmsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Kms
      with AwsServiceBase[R] {
    override val serviceName: String = "Kms"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KmsImpl[R1] = new KmsImpl(api, newAspect, r)
    def deleteImportedKeyMaterial(
        request: DeleteImportedKeyMaterialRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.DeleteImportedKeyMaterialRequest,
      DeleteImportedKeyMaterialResponse
    ]("deleteImportedKeyMaterial", api.deleteImportedKeyMaterial)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putKeyPolicy(request: PutKeyPolicyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.PutKeyPolicyRequest,
        PutKeyPolicyResponse
      ]("putKeyPolicy", api.putKeyPolicy)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeCustomKeyStores(
        request: DescribeCustomKeyStoresRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest,
      CustomKeyStoresListEntry,
      DescribeCustomKeyStoresPublisher
    ](
      "describeCustomKeyStores",
      api.describeCustomKeyStoresPaginator,
      _.customKeyStores()
    )(request.buildAwsValue())
      .map(item => zio.aws.kms.model.CustomKeyStoresListEntry.wrap(item))
      .provideEnvironment(r)
    def describeCustomKeyStoresPaginated(
        request: DescribeCustomKeyStoresRequest
    ): IO[
      AwsError,
      zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.DescribeCustomKeyStoresRequest,
      DescribeCustomKeyStoresResponse
    ]("describeCustomKeyStores", api.describeCustomKeyStores)(
      request.buildAwsValue()
    ).map(zio.aws.kms.model.DescribeCustomKeyStoresResponse.wrap)
      .provideEnvironment(r)
    def importKeyMaterial(
        request: ImportKeyMaterialRequest
    ): IO[AwsError, zio.aws.kms.model.ImportKeyMaterialResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ImportKeyMaterialRequest,
        ImportKeyMaterialResponse
      ]("importKeyMaterial", api.importKeyMaterial)(request.buildAwsValue())
        .map(zio.aws.kms.model.ImportKeyMaterialResponse.wrap)
        .provideEnvironment(r)
    def generateDataKeyWithoutPlaintext(
        request: GenerateDataKeyWithoutPlaintextRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.GenerateDataKeyWithoutPlaintextRequest,
      GenerateDataKeyWithoutPlaintextResponse
    ]("generateDataKeyWithoutPlaintext", api.generateDataKeyWithoutPlaintext)(
      request.buildAwsValue()
    ).map(zio.aws.kms.model.GenerateDataKeyWithoutPlaintextResponse.wrap)
      .provideEnvironment(r)
    def scheduleKeyDeletion(
        request: ScheduleKeyDeletionRequest
    ): IO[AwsError, zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ScheduleKeyDeletionRequest,
        ScheduleKeyDeletionResponse
      ]("scheduleKeyDeletion", api.scheduleKeyDeletion)(request.buildAwsValue())
        .map(zio.aws.kms.model.ScheduleKeyDeletionResponse.wrap)
        .provideEnvironment(r)
    def listRetirableGrants(
        request: ListRetirableGrantsRequest
    ): ZStream[Any, AwsError, zio.aws.kms.model.GrantListEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest,
        GrantListEntry,
        ListRetirableGrantsPublisher
      ]("listRetirableGrants", api.listRetirableGrantsPaginator, _.grants())(
        request.buildAwsValue()
      ).map(item => zio.aws.kms.model.GrantListEntry.wrap(item))
        .provideEnvironment(r)
    def listRetirableGrantsPaginated(
        request: ListRetirableGrantsRequest
    ): IO[AwsError, zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListRetirableGrantsRequest,
        ListRetirableGrantsResponse
      ]("listRetirableGrants", api.listRetirableGrants)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListRetirableGrantsResponse.wrap)
        .provideEnvironment(r)
    def generateMac(
        request: GenerateMacRequest
    ): IO[AwsError, zio.aws.kms.model.GenerateMacResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GenerateMacRequest,
        GenerateMacResponse
      ]("generateMac", api.generateMac)(request.buildAwsValue())
        .map(zio.aws.kms.model.GenerateMacResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomKeyStore(
        request: DeleteCustomKeyStoreRequest
    ): IO[AwsError, zio.aws.kms.model.DeleteCustomKeyStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.DeleteCustomKeyStoreRequest,
        DeleteCustomKeyStoreResponse
      ]("deleteCustomKeyStore", api.deleteCustomKeyStore)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.DeleteCustomKeyStoreResponse.wrap)
        .provideEnvironment(r)
    def replicateKey(
        request: ReplicateKeyRequest
    ): IO[AwsError, zio.aws.kms.model.ReplicateKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ReplicateKeyRequest,
        ReplicateKeyResponse
      ]("replicateKey", api.replicateKey)(request.buildAwsValue())
        .map(zio.aws.kms.model.ReplicateKeyResponse.wrap)
        .provideEnvironment(r)
    def revokeGrant(request: RevokeGrantRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.RevokeGrantRequest,
        RevokeGrantResponse
      ]("revokeGrant", api.revokeGrant)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def enableKeyRotation(
        request: EnableKeyRotationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.EnableKeyRotationRequest,
      EnableKeyRotationResponse
    ]("enableKeyRotation", api.enableKeyRotation)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def createGrant(
        request: CreateGrantRequest
    ): IO[AwsError, zio.aws.kms.model.CreateGrantResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.CreateGrantRequest,
        CreateGrantResponse
      ]("createGrant", api.createGrant)(request.buildAwsValue())
        .map(zio.aws.kms.model.CreateGrantResponse.wrap)
        .provideEnvironment(r)
    def cancelKeyDeletion(
        request: CancelKeyDeletionRequest
    ): IO[AwsError, zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.CancelKeyDeletionRequest,
        CancelKeyDeletionResponse
      ]("cancelKeyDeletion", api.cancelKeyDeletion)(request.buildAwsValue())
        .map(zio.aws.kms.model.CancelKeyDeletionResponse.wrap)
        .provideEnvironment(r)
    def decrypt(
        request: DecryptRequest
    ): IO[AwsError, zio.aws.kms.model.DecryptResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.DecryptRequest,
        DecryptResponse
      ]("decrypt", api.decrypt)(request.buildAwsValue())
        .map(zio.aws.kms.model.DecryptResponse.wrap)
        .provideEnvironment(r)
    def generateDataKeyPair(
        request: GenerateDataKeyPairRequest
    ): IO[AwsError, zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GenerateDataKeyPairRequest,
        GenerateDataKeyPairResponse
      ]("generateDataKeyPair", api.generateDataKeyPair)(request.buildAwsValue())
        .map(zio.aws.kms.model.GenerateDataKeyPairResponse.wrap)
        .provideEnvironment(r)
    def verify(
        request: VerifyRequest
    ): IO[AwsError, zio.aws.kms.model.VerifyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.VerifyRequest,
        VerifyResponse
      ]("verify", api.verify)(request.buildAwsValue())
        .map(zio.aws.kms.model.VerifyResponse.wrap)
        .provideEnvironment(r)
    def connectCustomKeyStore(
        request: ConnectCustomKeyStoreRequest
    ): IO[AwsError, zio.aws.kms.model.ConnectCustomKeyStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ConnectCustomKeyStoreRequest,
        ConnectCustomKeyStoreResponse
      ]("connectCustomKeyStore", api.connectCustomKeyStore)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.ConnectCustomKeyStoreResponse.wrap)
        .provideEnvironment(r)
    def sign(
        request: SignRequest
    ): IO[AwsError, zio.aws.kms.model.SignResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.SignRequest,
        SignResponse
      ]("sign", api.sign)(request.buildAwsValue())
        .map(zio.aws.kms.model.SignResponse.wrap)
        .provideEnvironment(r)
    def getPublicKey(
        request: GetPublicKeyRequest
    ): IO[AwsError, zio.aws.kms.model.GetPublicKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GetPublicKeyRequest,
        GetPublicKeyResponse
      ]("getPublicKey", api.getPublicKey)(request.buildAwsValue())
        .map(zio.aws.kms.model.GetPublicKeyResponse.wrap)
        .provideEnvironment(r)
    def updateKeyDescription(
        request: UpdateKeyDescriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.UpdateKeyDescriptionRequest,
      UpdateKeyDescriptionResponse
    ]("updateKeyDescription", api.updateKeyDescription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def reEncrypt(
        request: ReEncryptRequest
    ): IO[AwsError, zio.aws.kms.model.ReEncryptResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ReEncryptRequest,
        ReEncryptResponse
      ]("reEncrypt", api.reEncrypt)(request.buildAwsValue())
        .map(zio.aws.kms.model.ReEncryptResponse.wrap)
        .provideEnvironment(r)
    def generateDataKeyPairWithoutPlaintext(
        request: GenerateDataKeyPairWithoutPlaintextRequest
    ): IO[
      AwsError,
      zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.GenerateDataKeyPairWithoutPlaintextRequest,
      GenerateDataKeyPairWithoutPlaintextResponse
    ](
      "generateDataKeyPairWithoutPlaintext",
      api.generateDataKeyPairWithoutPlaintext
    )(request.buildAwsValue())
      .map(zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.wrap)
      .provideEnvironment(r)
    def getKeyRotationStatus(
        request: GetKeyRotationStatusRequest
    ): IO[AwsError, zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GetKeyRotationStatusRequest,
        GetKeyRotationStatusResponse
      ]("getKeyRotationStatus", api.getKeyRotationStatus)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.GetKeyRotationStatusResponse.wrap)
        .provideEnvironment(r)
    def listAliases(
        request: ListAliasesRequest
    ): ZStream[Any, AwsError, zio.aws.kms.model.AliasListEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.kms.model.ListAliasesRequest,
        AliasListEntry,
        ListAliasesPublisher
      ]("listAliases", api.listAliasesPaginator, _.aliases())(
        request.buildAwsValue()
      ).map(item => zio.aws.kms.model.AliasListEntry.wrap(item))
        .provideEnvironment(r)
    def listAliasesPaginated(
        request: ListAliasesRequest
    ): IO[AwsError, zio.aws.kms.model.ListAliasesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListAliasesRequest,
        ListAliasesResponse
      ]("listAliases", api.listAliases)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListAliasesResponse.wrap)
        .provideEnvironment(r)
    def getParametersForImport(
        request: GetParametersForImportRequest
    ): IO[AwsError, zio.aws.kms.model.GetParametersForImportResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GetParametersForImportRequest,
        GetParametersForImportResponse
      ]("getParametersForImport", api.getParametersForImport)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.GetParametersForImportResponse.wrap)
        .provideEnvironment(r)
    def verifyMac(
        request: VerifyMacRequest
    ): IO[AwsError, zio.aws.kms.model.VerifyMacResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.VerifyMacRequest,
        VerifyMacResponse
      ]("verifyMac", api.verifyMac)(request.buildAwsValue())
        .map(zio.aws.kms.model.VerifyMacResponse.wrap)
        .provideEnvironment(r)
    def encrypt(
        request: EncryptRequest
    ): IO[AwsError, zio.aws.kms.model.EncryptResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.EncryptRequest,
        EncryptResponse
      ]("encrypt", api.encrypt)(request.buildAwsValue())
        .map(zio.aws.kms.model.EncryptResponse.wrap)
        .provideEnvironment(r)
    def updateAlias(request: UpdateAliasRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.UpdateAliasRequest,
        UpdateAliasResponse
      ]("updateAlias", api.updateAlias)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createAlias(request: CreateAliasRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.CreateAliasRequest,
        CreateAliasResponse
      ]("createAlias", api.createAlias)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def disconnectCustomKeyStore(request: DisconnectCustomKeyStoreRequest): IO[
      AwsError,
      zio.aws.kms.model.DisconnectCustomKeyStoreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.DisconnectCustomKeyStoreRequest,
      DisconnectCustomKeyStoreResponse
    ]("disconnectCustomKeyStore", api.disconnectCustomKeyStore)(
      request.buildAwsValue()
    ).map(zio.aws.kms.model.DisconnectCustomKeyStoreResponse.wrap)
      .provideEnvironment(r)
    def disableKey(request: DisableKeyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.DisableKeyRequest,
        DisableKeyResponse
      ]("disableKey", api.disableKey)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def generateRandom(
        request: GenerateRandomRequest
    ): IO[AwsError, zio.aws.kms.model.GenerateRandomResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GenerateRandomRequest,
        GenerateRandomResponse
      ]("generateRandom", api.generateRandom)(request.buildAwsValue())
        .map(zio.aws.kms.model.GenerateRandomResponse.wrap)
        .provideEnvironment(r)
    def listGrants(
        request: ListGrantsRequest
    ): ZStream[Any, AwsError, zio.aws.kms.model.GrantListEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.kms.model.ListGrantsRequest,
        GrantListEntry,
        ListGrantsPublisher
      ]("listGrants", api.listGrantsPaginator, _.grants())(
        request.buildAwsValue()
      ).map(item => zio.aws.kms.model.GrantListEntry.wrap(item))
        .provideEnvironment(r)
    def listGrantsPaginated(
        request: ListGrantsRequest
    ): IO[AwsError, zio.aws.kms.model.ListGrantsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListGrantsRequest,
        ListGrantsResponse
      ]("listGrants", api.listGrants)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListGrantsResponse.wrap)
        .provideEnvironment(r)
    def updatePrimaryRegion(
        request: UpdatePrimaryRegionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.UpdatePrimaryRegionRequest,
      UpdatePrimaryRegionResponse
    ]("updatePrimaryRegion", api.updatePrimaryRegion)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createKey(
        request: CreateKeyRequest
    ): IO[AwsError, zio.aws.kms.model.CreateKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.CreateKeyRequest,
        CreateKeyResponse
      ]("createKey", api.createKey)(request.buildAwsValue())
        .map(zio.aws.kms.model.CreateKeyResponse.wrap)
        .provideEnvironment(r)
    def enableKey(request: EnableKeyRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.EnableKeyRequest,
        EnableKeyResponse
      ]("enableKey", api.enableKey)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteAlias(request: DeleteAliasRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.DeleteAliasRequest,
        DeleteAliasResponse
      ]("deleteAlias", api.deleteAlias)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getKeyPolicy(
        request: GetKeyPolicyRequest
    ): IO[AwsError, zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GetKeyPolicyRequest,
        GetKeyPolicyResponse
      ]("getKeyPolicy", api.getKeyPolicy)(request.buildAwsValue())
        .map(zio.aws.kms.model.GetKeyPolicyResponse.wrap)
        .provideEnvironment(r)
    def listKeyPolicies(
        request: ListKeyPoliciesRequest
    ): ZStream[Any, AwsError, PolicyNameType] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest,
      java.lang.String,
      ListKeyPoliciesPublisher
    ]("listKeyPolicies", api.listKeyPoliciesPaginator, _.policyNames())(
      request.buildAwsValue()
    ).map(item => zio.aws.kms.model.primitives.PolicyNameType(item))
      .provideEnvironment(r)
    def listKeyPoliciesPaginated(
        request: ListKeyPoliciesRequest
    ): IO[AwsError, zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListKeyPoliciesRequest,
        ListKeyPoliciesResponse
      ]("listKeyPolicies", api.listKeyPolicies)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListKeyPoliciesResponse.wrap)
        .provideEnvironment(r)
    def disableKeyRotation(
        request: DisableKeyRotationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.kms.model.DisableKeyRotationRequest,
      DisableKeyRotationResponse
    ]("disableKeyRotation", api.disableKeyRotation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def generateDataKey(
        request: GenerateDataKeyRequest
    ): IO[AwsError, zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.GenerateDataKeyRequest,
        GenerateDataKeyResponse
      ]("generateDataKey", api.generateDataKey)(request.buildAwsValue())
        .map(zio.aws.kms.model.GenerateDataKeyResponse.wrap)
        .provideEnvironment(r)
    def updateCustomKeyStore(
        request: UpdateCustomKeyStoreRequest
    ): IO[AwsError, zio.aws.kms.model.UpdateCustomKeyStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.UpdateCustomKeyStoreRequest,
        UpdateCustomKeyStoreResponse
      ]("updateCustomKeyStore", api.updateCustomKeyStore)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.UpdateCustomKeyStoreResponse.wrap)
        .provideEnvironment(r)
    def retireGrant(request: RetireGrantRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.RetireGrantRequest,
        RetireGrantResponse
      ]("retireGrant", api.retireGrant)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createCustomKeyStore(
        request: CreateCustomKeyStoreRequest
    ): IO[AwsError, zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.CreateCustomKeyStoreRequest,
        CreateCustomKeyStoreResponse
      ]("createCustomKeyStore", api.createCustomKeyStore)(
        request.buildAwsValue()
      ).map(zio.aws.kms.model.CreateCustomKeyStoreResponse.wrap)
        .provideEnvironment(r)
    def listResourceTags(
        request: ListResourceTagsRequest
    ): ZStream[Any, AwsError, zio.aws.kms.model.Tag.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.kms.model.ListResourceTagsRequest,
        Tag,
        ListResourceTagsPublisher
      ]("listResourceTags", api.listResourceTagsPaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.kms.model.Tag.wrap(item)).provideEnvironment(r)
    def listResourceTagsPaginated(
        request: ListResourceTagsRequest
    ): IO[AwsError, zio.aws.kms.model.ListResourceTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListResourceTagsRequest,
        ListResourceTagsResponse
      ]("listResourceTags", api.listResourceTags)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListResourceTagsResponse.wrap)
        .provideEnvironment(r)
    def describeKey(
        request: DescribeKeyRequest
    ): IO[AwsError, zio.aws.kms.model.DescribeKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.DescribeKeyRequest,
        DescribeKeyResponse
      ]("describeKey", api.describeKey)(request.buildAwsValue())
        .map(zio.aws.kms.model.DescribeKeyResponse.wrap)
        .provideEnvironment(r)
    def listKeys(
        request: ListKeysRequest
    ): ZStream[Any, AwsError, zio.aws.kms.model.KeyListEntry.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.kms.model.ListKeysRequest,
        KeyListEntry,
        ListKeysPublisher
      ]("listKeys", api.listKeysPaginator, _.keys())(request.buildAwsValue())
        .map(item => zio.aws.kms.model.KeyListEntry.wrap(item))
        .provideEnvironment(r)
    def listKeysPaginated(
        request: ListKeysRequest
    ): IO[AwsError, zio.aws.kms.model.ListKeysResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kms.model.ListKeysRequest,
        ListKeysResponse
      ]("listKeys", api.listKeys)(request.buildAwsValue())
        .map(zio.aws.kms.model.ListKeysResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteImportedKeyMaterial(
      request: DeleteImportedKeyMaterialRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteImportedKeyMaterial(request))
  def putKeyPolicy(
      request: PutKeyPolicyRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putKeyPolicy(request))
  def describeCustomKeyStores(request: DescribeCustomKeyStoresRequest): ZStream[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.CustomKeyStoresListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCustomKeyStores(request))
  def describeCustomKeyStoresPaginated(
      request: DescribeCustomKeyStoresRequest
  ): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.DescribeCustomKeyStoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomKeyStoresPaginated(request))
  def importKeyMaterial(request: ImportKeyMaterialRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ImportKeyMaterialResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importKeyMaterial(request))
  def generateDataKeyWithoutPlaintext(
      request: GenerateDataKeyWithoutPlaintextRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.generateDataKeyWithoutPlaintext(request))
  def scheduleKeyDeletion(request: ScheduleKeyDeletionRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ScheduleKeyDeletionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.scheduleKeyDeletion(request))
  def listRetirableGrants(request: ListRetirableGrantsRequest): ZStream[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GrantListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listRetirableGrants(request))
  def listRetirableGrantsPaginated(request: ListRetirableGrantsRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListRetirableGrantsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRetirableGrantsPaginated(request))
  def generateMac(request: GenerateMacRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GenerateMacResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateMac(request))
  def deleteCustomKeyStore(request: DeleteCustomKeyStoreRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.DeleteCustomKeyStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCustomKeyStore(request))
  def replicateKey(request: ReplicateKeyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ReplicateKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replicateKey(request))
  def revokeGrant(
      request: RevokeGrantRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.revokeGrant(request))
  def enableKeyRotation(
      request: EnableKeyRotationRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableKeyRotation(request))
  def createGrant(request: CreateGrantRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.CreateGrantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGrant(request))
  def cancelKeyDeletion(request: CancelKeyDeletionRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.CancelKeyDeletionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelKeyDeletion(request))
  def decrypt(request: DecryptRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.DecryptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.decrypt(request))
  def generateDataKeyPair(request: GenerateDataKeyPairRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GenerateDataKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateDataKeyPair(request))
  def verify(
      request: VerifyRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, zio.aws.kms.model.VerifyResponse.ReadOnly] =
    ZIO.serviceWithZIO(_.verify(request))
  def connectCustomKeyStore(request: ConnectCustomKeyStoreRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ConnectCustomKeyStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.connectCustomKeyStore(request))
  def sign(
      request: SignRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, zio.aws.kms.model.SignResponse.ReadOnly] =
    ZIO.serviceWithZIO(_.sign(request))
  def getPublicKey(request: GetPublicKeyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GetPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicKey(request))
  def updateKeyDescription(
      request: UpdateKeyDescriptionRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateKeyDescription(request))
  def reEncrypt(request: ReEncryptRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ReEncryptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.reEncrypt(request))
  def generateDataKeyPairWithoutPlaintext(
      request: GenerateDataKeyPairWithoutPlaintextRequest
  ): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GenerateDataKeyPairWithoutPlaintextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateDataKeyPairWithoutPlaintext(request))
  def getKeyRotationStatus(request: GetKeyRotationStatusRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GetKeyRotationStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyRotationStatus(request))
  def listAliases(request: ListAliasesRequest): ZStream[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.AliasListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listAliases(request))
  def listAliasesPaginated(request: ListAliasesRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAliasesPaginated(request))
  def getParametersForImport(request: GetParametersForImportRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GetParametersForImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParametersForImport(request))
  def verifyMac(request: VerifyMacRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.VerifyMacResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifyMac(request))
  def encrypt(request: EncryptRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.EncryptResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.encrypt(request))
  def updateAlias(
      request: UpdateAliasRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateAlias(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def createAlias(
      request: CreateAliasRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createAlias(request))
  def disconnectCustomKeyStore(request: DisconnectCustomKeyStoreRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.DisconnectCustomKeyStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disconnectCustomKeyStore(request))
  def disableKey(
      request: DisableKeyRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableKey(request))
  def generateRandom(request: GenerateRandomRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GenerateRandomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateRandom(request))
  def listGrants(request: ListGrantsRequest): ZStream[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GrantListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listGrants(request))
  def listGrantsPaginated(request: ListGrantsRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListGrantsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGrantsPaginated(request))
  def updatePrimaryRegion(
      request: UpdatePrimaryRegionRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updatePrimaryRegion(request))
  def createKey(request: CreateKeyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.CreateKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKey(request))
  def enableKey(
      request: EnableKeyRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableKey(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def deleteAlias(
      request: DeleteAliasRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAlias(request))
  def getKeyPolicy(request: GetKeyPolicyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GetKeyPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKeyPolicy(request))
  def listKeyPolicies(
      request: ListKeyPoliciesRequest
  ): ZStream[zio.aws.kms.Kms, AwsError, PolicyNameType] =
    ZStream.serviceWithStream(_.listKeyPolicies(request))
  def listKeyPoliciesPaginated(request: ListKeyPoliciesRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListKeyPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeyPoliciesPaginated(request))
  def disableKeyRotation(
      request: DisableKeyRotationRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableKeyRotation(request))
  def generateDataKey(request: GenerateDataKeyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.GenerateDataKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateDataKey(request))
  def updateCustomKeyStore(request: UpdateCustomKeyStoreRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.UpdateCustomKeyStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCustomKeyStore(request))
  def retireGrant(
      request: RetireGrantRequest
  ): ZIO[zio.aws.kms.Kms, AwsError, Unit] =
    ZIO.serviceWithZIO(_.retireGrant(request))
  def createCustomKeyStore(request: CreateCustomKeyStoreRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.CreateCustomKeyStoreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomKeyStore(request))
  def listResourceTags(
      request: ListResourceTagsRequest
  ): ZStream[zio.aws.kms.Kms, AwsError, zio.aws.kms.model.Tag.ReadOnly] =
    ZStream.serviceWithStream(_.listResourceTags(request))
  def listResourceTagsPaginated(request: ListResourceTagsRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListResourceTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceTagsPaginated(request))
  def describeKey(request: DescribeKeyRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.DescribeKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKey(request))
  def listKeys(request: ListKeysRequest): ZStream[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.KeyListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listKeys(request))
  def listKeysPaginated(request: ListKeysRequest): ZIO[
    zio.aws.kms.Kms,
    AwsError,
    zio.aws.kms.model.ListKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeysPaginated(request))
}
