package zio.aws.kms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kms.model.primitives.{
  GrantTokenType,
  CiphertextType,
  PlaintextType,
  KeyIdType
}
import scala.jdk.CollectionConverters._
final case class VerifyRequest(
    keyId: KeyIdType,
    message: PlaintextType,
    messageType: Option[zio.aws.kms.model.MessageType] = None,
    signature: CiphertextType,
    signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec,
    grantTokens: Option[Iterable[GrantTokenType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kms.model.VerifyRequest = {
    import VerifyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kms.model.VerifyRequest
      .builder()
      .keyId(KeyIdType.unwrap(keyId): java.lang.String)
      .message(
        software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
          message.toArray[Byte]
        )
      )
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .signature(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(signature.toArray[Byte])
      )
      .signingAlgorithm(signingAlgorithm.unwrap)
      .optionallyWith(
        grantTokens.map(value =>
          value.map { item =>
            GrantTokenType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.grantTokens)
      .build()
  }
  def asReadOnly: zio.aws.kms.model.VerifyRequest.ReadOnly =
    zio.aws.kms.model.VerifyRequest.wrap(buildAwsValue())
}
object VerifyRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kms.model.VerifyRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kms.model.VerifyRequest =
      zio.aws.kms.model.VerifyRequest(
        keyId,
        message,
        messageType.map(value => value),
        signature,
        signingAlgorithm,
        grantTokens.map(value => value)
      )
    def keyId: KeyIdType
    def message: PlaintextType
    def messageType: Option[zio.aws.kms.model.MessageType]
    def signature: CiphertextType
    def signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec
    def grantTokens: Option[List[GrantTokenType]]
    def getKeyId: ZIO[Any, Nothing, KeyIdType] = ZIO.succeed(keyId)
    def getMessage: ZIO[Any, Nothing, PlaintextType] = ZIO.succeed(message)
    def getMessageType: ZIO[Any, AwsError, zio.aws.kms.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getSignature: ZIO[Any, Nothing, CiphertextType] = ZIO.succeed(signature)
    def getSigningAlgorithm
        : ZIO[Any, Nothing, zio.aws.kms.model.SigningAlgorithmSpec] =
      ZIO.succeed(signingAlgorithm)
    def getGrantTokens: ZIO[Any, AwsError, List[GrantTokenType]] =
      AwsError.unwrapOptionField("grantTokens", grantTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kms.model.VerifyRequest
  ) extends zio.aws.kms.model.VerifyRequest.ReadOnly {
    override val keyId: KeyIdType =
      zio.aws.kms.model.primitives.KeyIdType(impl.keyId())
    override val message: PlaintextType = zio.aws.kms.model.primitives
      .PlaintextType(zio.Chunk.fromArray(impl.message().asByteArrayUnsafe()))
    override val messageType: Option[zio.aws.kms.model.MessageType] = scala
      .Option(impl.messageType())
      .map(value => zio.aws.kms.model.MessageType.wrap(value))
    override val signature: CiphertextType = zio.aws.kms.model.primitives
      .CiphertextType(zio.Chunk.fromArray(impl.signature().asByteArrayUnsafe()))
    override val signingAlgorithm: zio.aws.kms.model.SigningAlgorithmSpec =
      zio.aws.kms.model.SigningAlgorithmSpec.wrap(impl.signingAlgorithm())
    override val grantTokens: Option[List[GrantTokenType]] = scala
      .Option(impl.grantTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kms.model.primitives.GrantTokenType(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kms.model.VerifyRequest
  ): zio.aws.kms.model.VerifyRequest.ReadOnly = new Wrapper(impl)
}
