package zio.aws.kms.model
import scala.jdk.CollectionConverters._
sealed trait SigningAlgorithmSpec {
  def unwrap: software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec
}
object SigningAlgorithmSpec {
  def wrap(
      value: software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec
  ): zio.aws.kms.model.SigningAlgorithmSpec = value match {
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_256 =>
      val r = RSASSA_PSS_SHA_256
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_384 =>
      val r = RSASSA_PSS_SHA_384
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_512 =>
      val r = RSASSA_PSS_SHA_512
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_256 =>
      val r = RSASSA_PKCS1_V1_5_SHA_256
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_384 =>
      val r = RSASSA_PKCS1_V1_5_SHA_384
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_512 =>
      val r = RSASSA_PKCS1_V1_5_SHA_512
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_256 =>
      val r = ECDSA_SHA_256
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_384 =>
      val r = ECDSA_SHA_384
      r
    case software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_512 =>
      val r = ECDSA_SHA_512
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.UNKNOWN_TO_SDK_VERSION
  }
  case object RSASSA_PSS_SHA_256
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_256
  }
  case object RSASSA_PSS_SHA_384
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_384
  }
  case object RSASSA_PSS_SHA_512
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PSS_SHA_512
  }
  case object RSASSA_PKCS1_V1_5_SHA_256
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_256
  }
  case object RSASSA_PKCS1_V1_5_SHA_384
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_384
  }
  case object RSASSA_PKCS1_V1_5_SHA_512
      extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.RSASSA_PKCS1_V1_5_SHA_512
  }
  case object ECDSA_SHA_256 extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_256
  }
  case object ECDSA_SHA_384 extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_384
  }
  case object ECDSA_SHA_512 extends zio.aws.kms.model.SigningAlgorithmSpec {
    override def unwrap
        : software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec =
      software.amazon.awssdk.services.kms.model.SigningAlgorithmSpec.ECDSA_SHA_512
  }
}
