package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.HLSStreamingSessionURL
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetHlsStreamingSessionUrlResponse(
    hlsStreamingSessionURL: Optional[HLSStreamingSessionURL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse = {
    import GetHlsStreamingSessionUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
      .builder()
      .optionallyWith(
        hlsStreamingSessionURL.map(value =>
          HLSStreamingSessionURL.unwrap(value): java.lang.String
        )
      )(_.hlsStreamingSessionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
      .wrap(buildAwsValue())
}
object GetHlsStreamingSessionUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse =
      zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse(
        hlsStreamingSessionURL.map(value => value)
      )
    def hlsStreamingSessionURL: Optional[HLSStreamingSessionURL]
    def getHlsStreamingSessionURL: ZIO[Any, AwsError, HLSStreamingSessionURL] =
      AwsError.unwrapOptionField(
        "hlsStreamingSessionURL",
        hlsStreamingSessionURL
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly {
    override val hlsStreamingSessionURL: Optional[HLSStreamingSessionURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hlsStreamingSessionURL())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .HLSStreamingSessionURL(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly =
    new Wrapper(impl)
}
