package zio.aws.kinesisvideoarchivedmedia
import zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.{
  KinesisVideoArchivedMediaAsyncClientBuilder,
  KinesisVideoArchivedMediaAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, Task, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.{
  Image,
  GetClipResponse,
  GetHlsStreamingSessionUrlResponse,
  GetDashStreamingSessionUrlResponse,
  Fragment,
  GetMediaForFragmentListResponse,
  GetClipRequest,
  GetMediaForFragmentListRequest,
  GetDashStreamingSessionUrlRequest,
  GetImagesResponse,
  ListFragmentsResponse,
  ListFragmentsRequest,
  GetHlsStreamingSessionUrlRequest,
  GetImagesRequest
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait KinesisVideoArchivedMedia
    extends AspectSupport[KinesisVideoArchivedMedia] {
  val api: KinesisVideoArchivedMediaAsyncClient
  def getMediaForFragmentList(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
  ): IO[AwsError, StreamingOutputResult[Any, ReadOnly, Byte]]
  def getHLSStreamingSessionURL(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
  ): IO[
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
  ]
  def getDASHStreamingSessionURL(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ): IO[
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
  ]
  def getClip(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
    Byte
  ]]
  def getImages(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
  ]
  def getImagesPaginated(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
  ): IO[
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly
  ]
  def listFragments(
      request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
  ]
  def listFragmentsPaginated(
      request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): IO[
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
  ]
}
object KinesisVideoArchivedMedia {
  val live: ZLayer[AwsConfig, java.lang.Throwable, KinesisVideoArchivedMedia] =
    customized(identity)
  def customized(
      customization: KinesisVideoArchivedMediaAsyncClientBuilder => KinesisVideoArchivedMediaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, KinesisVideoArchivedMedia] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KinesisVideoArchivedMediaAsyncClientBuilder => KinesisVideoArchivedMediaAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, KinesisVideoArchivedMedia] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = KinesisVideoArchivedMediaAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        KinesisVideoArchivedMediaAsyncClient,
        KinesisVideoArchivedMediaAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        KinesisVideoArchivedMediaAsyncClient,
        KinesisVideoArchivedMediaAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new KinesisVideoArchivedMediaImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class KinesisVideoArchivedMediaImpl[R](
      override val api: KinesisVideoArchivedMediaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends KinesisVideoArchivedMedia
      with AwsServiceBase[R] {
    override val serviceName: String = "KinesisVideoArchivedMedia"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KinesisVideoArchivedMediaImpl[R1] =
      new KinesisVideoArchivedMediaImpl(api, newAspect, r)
    def getMediaForFragmentList(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
    ): IO[AwsError, StreamingOutputResult[Any, ReadOnly, Byte]] =
      asyncRequestOutputStream[
        GetMediaForFragmentListRequest,
        GetMediaForFragmentListResponse
      ](
        "getMediaForFragmentList",
        api.getMediaForFragmentList[Task[
          StreamingOutputResult[R, GetMediaForFragmentListResponse, Byte]
        ]]
      )(request.buildAwsValue())
        .map(
          _.mapResponse(
            zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.wrap
          ).provideEnvironment(r)
        )
        .provideEnvironment(r)
    def getHLSStreamingSessionURL(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
    ): IO[
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      GetHlsStreamingSessionUrlRequest,
      GetHlsStreamingSessionUrlResponse
    ]("getHLSStreamingSessionURL", api.getHLSStreamingSessionURL)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.wrap
    ).provideEnvironment(r)
    def getDASHStreamingSessionURL(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
    ): IO[
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDashStreamingSessionUrlRequest,
      GetDashStreamingSessionUrlResponse
    ]("getDASHStreamingSessionURL", api.getDASHStreamingSessionURL)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.wrap
    ).provideEnvironment(r)
    def getClip(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
      Byte
    ]] = asyncRequestOutputStream[GetClipRequest, GetClipResponse](
      "getClip",
      api.getClip[Task[StreamingOutputResult[R, GetClipResponse, Byte]]]
    )(request.buildAwsValue())
      .map(
        _.mapResponse(
          zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.wrap
        ).provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getImages(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
    ] = asyncSimplePaginatedRequest[GetImagesRequest, GetImagesResponse, Image](
      "getImages",
      api.getImages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.images().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kinesisvideoarchivedmedia.model.Image.wrap(item))
      .provideEnvironment(r)
    def getImagesPaginated(
        request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
    ): IO[
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly
    ] = asyncRequestResponse[GetImagesRequest, GetImagesResponse](
      "getImages",
      api.getImages
    )(request.buildAwsValue())
      .map(zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.wrap)
      .provideEnvironment(r)
    def listFragments(
        request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListFragmentsRequest,
      ListFragmentsResponse,
      Fragment
    ](
      "listFragments",
      api.listFragments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fragments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kinesisvideoarchivedmedia.model.Fragment.wrap(item))
      .provideEnvironment(r)
    def listFragmentsPaginated(
        request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
    ): IO[
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
    ] = asyncRequestResponse[ListFragmentsRequest, ListFragmentsResponse](
      "listFragments",
      api.listFragments
    )(request.buildAwsValue())
      .map(zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.wrap)
      .provideEnvironment(r)
  }
  def getMediaForFragmentList(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    StreamingOutputResult[Any, ReadOnly, Byte]
  ] = ZIO.serviceWithZIO(_.getMediaForFragmentList(request))
  def getHLSStreamingSessionURL(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHLSStreamingSessionURL(request))
  def getDASHStreamingSessionURL(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDASHStreamingSessionURL(request))
  def getClip(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
      Byte
    ]
  ] = ZIO.serviceWithZIO(_.getClip(request))
  def getImages(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
  ): ZStream[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
  ] = ZStream.serviceWithStream(_.getImages(request))
  def getImagesPaginated(
      request: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImagesPaginated(request))
  def listFragments(
      request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): ZStream[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
  ] = ZStream.serviceWithStream(_.listFragments(request))
  def listFragmentsPaginated(
      request: zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): ZIO[
    zio.aws.kinesisvideoarchivedmedia.KinesisVideoArchivedMedia,
    AwsError,
    zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFragmentsPaginated(request))
}
