package zio.aws.kinesisvideoarchivedmedia.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  Timestamp,
  FragmentNumberString
}
import scala.jdk.CollectionConverters.*
final case class Fragment(
    fragmentNumber: Optional[FragmentNumberString] = Optional.Absent,
    fragmentSizeInBytes: Optional[Long] = Optional.Absent,
    producerTimestamp: Optional[Timestamp] = Optional.Absent,
    serverTimestamp: Optional[Timestamp] = Optional.Absent,
    fragmentLengthInMilliseconds: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment = {
    import Fragment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
      .builder()
      .optionallyWith(
        fragmentNumber.map(value =>
          FragmentNumberString.unwrap(value): java.lang.String
        )
      )(_.fragmentNumber)
      .optionallyWith(fragmentSizeInBytes.map(value => value: java.lang.Long))(
        _.fragmentSizeInBytes
      )
      .optionallyWith(
        producerTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.producerTimestamp)
      .optionallyWith(
        serverTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.serverTimestamp)
      .optionallyWith(
        fragmentLengthInMilliseconds.map(value => value: java.lang.Long)
      )(_.fragmentLengthInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.Fragment.wrap(buildAwsValue())
}
object Fragment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.Fragment =
      zio.aws.kinesisvideoarchivedmedia.model.Fragment(
        fragmentNumber.map(value => value),
        fragmentSizeInBytes.map(value => value),
        producerTimestamp.map(value => value),
        serverTimestamp.map(value => value),
        fragmentLengthInMilliseconds.map(value => value)
      )
    def fragmentNumber: Optional[FragmentNumberString]
    def fragmentSizeInBytes: Optional[Long]
    def producerTimestamp: Optional[Timestamp]
    def serverTimestamp: Optional[Timestamp]
    def fragmentLengthInMilliseconds: Optional[Long]
    def getFragmentNumber: ZIO[Any, AwsError, FragmentNumberString] =
      AwsError.unwrapOptionField("fragmentNumber", fragmentNumber)
    def getFragmentSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fragmentSizeInBytes", fragmentSizeInBytes)
    def getProducerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("producerTimestamp", producerTimestamp)
    def getServerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serverTimestamp", serverTimestamp)
    def getFragmentLengthInMilliseconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "fragmentLengthInMilliseconds",
        fragmentLengthInMilliseconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ) extends zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly {
    override val fragmentNumber: Optional[FragmentNumberString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentNumber())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .FragmentNumberString(value)
        )
    override val fragmentSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.fragmentSizeInBytes())
      .map(value => value: Long)
    override val producerTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.producerTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val serverTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.serverTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val fragmentLengthInMilliseconds: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fragmentLengthInMilliseconds())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ): zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly = new Wrapper(
    impl
  )
}
