package zio.aws.kinesisvideoarchivedmedia.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  DASHMaxResults,
  Expires,
  ResourceARN,
  StreamName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDashStreamingSessionUrlRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    playbackMode: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode
    ] = Optional.Absent,
    displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = Optional.Absent,
    displayFragmentNumber: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] = Optional.Absent,
    dashFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector
    ] = Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    maxManifestFragmentResults: Optional[DASHMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest = {
    import GetDashStreamingSessionUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(playbackMode.map(value => value.unwrap))(_.playbackMode)
      .optionallyWith(displayFragmentTimestamp.map(value => value.unwrap))(
        _.displayFragmentTimestamp
      )
      .optionallyWith(displayFragmentNumber.map(value => value.unwrap))(
        _.displayFragmentNumber
      )
      .optionallyWith(dashFragmentSelector.map(value => value.buildAwsValue()))(
        _.dashFragmentSelector
      )
      .optionallyWith(expires.map(value => Expires.unwrap(value): Integer))(
        _.expires
      )
      .optionallyWith(
        maxManifestFragmentResults.map(value =>
          DASHMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxManifestFragmentResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
      .wrap(buildAwsValue())
}
object GetDashStreamingSessionUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        playbackMode.map(value => value),
        displayFragmentTimestamp.map(value => value),
        displayFragmentNumber.map(value => value),
        dashFragmentSelector.map(value => value.asEditable),
        expires.map(value => value),
        maxManifestFragmentResults.map(value => value)
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def playbackMode
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode]
    def displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ]
    def displayFragmentNumber: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ]
    def dashFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ]
    def expires: Optional[Expires]
    def maxManifestFragmentResults: Optional[DASHMaxResults]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getPlaybackMode: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode
    ] = AwsError.unwrapOptionField("playbackMode", playbackMode)
    def getDisplayFragmentTimestamp: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = AwsError.unwrapOptionField(
      "displayFragmentTimestamp",
      displayFragmentTimestamp
    )
    def getDisplayFragmentNumber: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] =
      AwsError.unwrapOptionField("displayFragmentNumber", displayFragmentNumber)
    def getDashFragmentSelector: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ] = AwsError.unwrapOptionField("dashFragmentSelector", dashFragmentSelector)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getMaxManifestFragmentResults: ZIO[Any, AwsError, DASHMaxResults] =
      AwsError.unwrapOptionField(
        "maxManifestFragmentResults",
        maxManifestFragmentResults
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val playbackMode
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playbackMode())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode.wrap(value)
        )
    override val displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.displayFragmentTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
          .wrap(value)
      )
    override val displayFragmentNumber: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.displayFragmentNumber())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
          .wrap(value)
      )
    override val dashFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dashFragmentSelector())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.wrap(value)
      )
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Expires(value)
      )
    override val maxManifestFragmentResults: Optional[DASHMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxManifestFragmentResults())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .DASHMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly =
    new Wrapper(impl)
}
