package zio.aws.kinesisvideoarchivedmedia.model
import scala.jdk.CollectionConverters.*
sealed trait Format {
  def unwrap
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format
  ): zio.aws.kinesisvideoarchivedmedia.model.Format = value match {
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.JPEG =>
      val r = JPEG
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.PNG =>
      val r = PNG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisvideoarchivedmedia.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object JPEG extends zio.aws.kinesisvideoarchivedmedia.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.JPEG
  }
  case object PNG extends zio.aws.kinesisvideoarchivedmedia.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Format.PNG
  }
}
