package zio.aws.kinesisvideoarchivedmedia.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class DASHTimestampRange(
    startTimestamp: Optional[Timestamp] = Optional.Absent,
    endTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange = {
    import DASHTimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
      .builder()
      .optionallyWith(
        startTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange
      .wrap(buildAwsValue())
}
object DASHTimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange =
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange(
        startTimestamp.map(value => value),
        endTimestamp.map(value => value)
      )
    def startTimestamp: Optional[Timestamp]
    def endTimestamp: Optional[Timestamp]
    def getStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ) extends zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly {
    override val startTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val endTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ): zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly =
    new Wrapper(impl)
}
