package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ClipTimestampRange(
    startTimestamp: Timestamp,
    endTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipTimestampRange = {
    import ClipTimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipTimestampRange
      .builder()
      .startTimestamp(Timestamp.unwrap(startTimestamp): Instant)
      .endTimestamp(Timestamp.unwrap(endTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange
      .wrap(buildAwsValue())
}
object ClipTimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipTimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange =
      zio.aws.kinesisvideoarchivedmedia.model
        .ClipTimestampRange(startTimestamp, endTimestamp)
    def startTimestamp: Timestamp
    def endTimestamp: Timestamp
    def getStartTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startTimestamp)
    def getEndTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipTimestampRange
  ) extends zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly {
    override val startTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.startTimestamp())
    override val endTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.endTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipTimestampRange
  ): zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly =
    new Wrapper(impl)
}
