package zio.aws.kinesisvideoarchivedmedia.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  ImageContent,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class Image(
    timeStamp: Optional[Timestamp] = Optional.Absent,
    error: Optional[zio.aws.kinesisvideoarchivedmedia.model.ImageError] =
      Optional.Absent,
    imageContent: Optional[ImageContent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image
      .builder()
      .optionallyWith(timeStamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timeStamp
      )
      .optionallyWith(error.map(value => value.unwrap))(_.error)
      .optionallyWith(
        imageContent.map(value => ImageContent.unwrap(value): java.lang.String)
      )(_.imageContent)
      .build()
  }
  def asReadOnly: zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.Image =
      zio.aws.kinesisvideoarchivedmedia.model.Image(
        timeStamp.map(value => value),
        error.map(value => value),
        imageContent.map(value => value)
      )
    def timeStamp: Optional[Timestamp]
    def error: Optional[zio.aws.kinesisvideoarchivedmedia.model.ImageError]
    def imageContent: Optional[ImageContent]
    def getTimeStamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timeStamp", timeStamp)
    def getError: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.ImageError
    ] = AwsError.unwrapOptionField("error", error)
    def getImageContent: ZIO[Any, AwsError, ImageContent] =
      AwsError.unwrapOptionField("imageContent", imageContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image
  ) extends zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly {
    override val timeStamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timeStamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val error
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.ImageError] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.ImageError.wrap(value)
        )
    override val imageContent: Optional[ImageContent] = zio.aws.core.internal
      .optionalFromNullable(impl.imageContent())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ImageContent(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Image
  ): zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly = new Wrapper(impl)
}
