package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.ContentType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetClipResponse(
    contentType: Optional[ContentType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse = {
    import GetClipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse
      .builder()
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse
      .wrap(buildAwsValue())
}
object GetClipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse =
      zio.aws.kinesisvideoarchivedmedia.model
        .GetClipResponse(contentType.map(value => value))
    def contentType: Optional[ContentType]
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly {
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ContentType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly =
    new Wrapper(impl)
}
