package zio.aws.kinesisvideoarchivedmedia.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DASHFragmentSelector(
    fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelectorType
    ] = Optional.Absent,
    timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector = {
    import DASHFragmentSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector
      .builder()
      .optionallyWith(fragmentSelectorType.map(value => value.unwrap))(
        _.fragmentSelectorType
      )
      .optionallyWith(timestampRange.map(value => value.buildAwsValue()))(
        _.timestampRange
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector
      .wrap(buildAwsValue())
}
object DASHFragmentSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector =
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector(
        fragmentSelectorType.map(value => value),
        timestampRange.map(value => value.asEditable)
      )
    def fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelectorType
    ]
    def timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly
    ]
    def getFragmentSelectorType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelectorType
    ] = AwsError.unwrapOptionField("fragmentSelectorType", fragmentSelectorType)
    def getTimestampRange: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly
    ] = AwsError.unwrapOptionField("timestampRange", timestampRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector
  ) extends zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly {
    override val fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelectorType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fragmentSelectorType())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelectorType
          .wrap(value)
      )
    override val timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestampRange())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector
  ): zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly =
    new Wrapper(impl)
}
