package zio.aws.kinesisvideoarchivedmedia
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  FragmentNumberString,
  FormatConfigValue
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ContentType extends Subtype[String]
    type ContentType =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.ContentType.Type
    object DASHMaxResults extends Subtype[Long]
    type DASHMaxResults =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.DASHMaxResults.Type
    object DASHStreamingSessionURL extends Subtype[String]
    type DASHStreamingSessionURL =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.DASHStreamingSessionURL.Type
    object Expires extends Subtype[Int]
    type Expires =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.Expires.Type
    object FormatConfigValue extends Subtype[String]
    type FormatConfigValue =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.FormatConfigValue.Type
    object FragmentNumberString extends Subtype[String]
    type FragmentNumberString =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.FragmentNumberString.Type
    object GetImagesMaxResults extends Subtype[Long]
    type GetImagesMaxResults =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.GetImagesMaxResults.Type
    object HLSMaxResults extends Subtype[Long]
    type HLSMaxResults =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.HLSMaxResults.Type
    object HLSStreamingSessionURL extends Subtype[String]
    type HLSStreamingSessionURL =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.HLSStreamingSessionURL.Type
    object HeightPixels extends Subtype[Int]
    type HeightPixels =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.HeightPixels.Type
    object ImageContent extends Subtype[String]
    type ImageContent =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.ImageContent.Type
    object ListFragmentsMaxResults extends Subtype[Long]
    type ListFragmentsMaxResults =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.ListFragmentsMaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken.Type
    object Payload extends Subtype[Chunk[Byte]]
    type Payload =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.Payload.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN.Type
    object SamplingInterval extends Subtype[Int]
    type SamplingInterval =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.SamplingInterval.Type
    object StreamName extends Subtype[String]
    type StreamName =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp.Type
    object WidthPixels extends Subtype[Int]
    type WidthPixels =
      zio.aws.kinesisvideoarchivedmedia.model.primitives.WidthPixels.Type
  }
  type FormatConfig = Map[
    zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey,
    FormatConfigValue
  ]
  type FragmentList = List[zio.aws.kinesisvideoarchivedmedia.model.Fragment]
  type FragmentNumberList = List[FragmentNumberString]
  type Images = List[zio.aws.kinesisvideoarchivedmedia.model.Image]
}
