package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFragmentsResponse(
    fragments: Optional[
      Iterable[zio.aws.kinesisvideoarchivedmedia.model.Fragment]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse = {
    import ListFragmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse
      .builder()
      .optionallyWith(
        fragments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fragments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse
      .wrap(buildAwsValue())
}
object ListFragmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse =
      zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse(
        fragments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fragments: Optional[
      List[zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getFragments: ZIO[Any, AwsError, List[
      zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
    ]] = AwsError.unwrapOptionField("fragments", fragments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly {
    override val fragments: Optional[
      List[zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fragments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisvideoarchivedmedia.model.Fragment.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly =
    new Wrapper(impl)
}
