package zio.aws.kinesisvideoarchivedmedia.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  HLSMaxResults,
  Expires,
  ResourceARN,
  StreamName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetHlsStreamingSessionUrlRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    playbackMode: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode
    ] = Optional.Absent,
    hlsFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector
    ] = Optional.Absent,
    containerFormat: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat
    ] = Optional.Absent,
    discontinuityMode: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode
    ] = Optional.Absent,
    displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp
    ] = Optional.Absent,
    expires: Optional[Expires] = Optional.Absent,
    maxMediaPlaylistFragmentResults: Optional[HLSMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest = {
    import GetHlsStreamingSessionUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(playbackMode.map(value => value.unwrap))(_.playbackMode)
      .optionallyWith(hlsFragmentSelector.map(value => value.buildAwsValue()))(
        _.hlsFragmentSelector
      )
      .optionallyWith(containerFormat.map(value => value.unwrap))(
        _.containerFormat
      )
      .optionallyWith(discontinuityMode.map(value => value.unwrap))(
        _.discontinuityMode
      )
      .optionallyWith(displayFragmentTimestamp.map(value => value.unwrap))(
        _.displayFragmentTimestamp
      )
      .optionallyWith(expires.map(value => Expires.unwrap(value): Integer))(
        _.expires
      )
      .optionallyWith(
        maxMediaPlaylistFragmentResults.map(value =>
          HLSMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxMediaPlaylistFragmentResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
      .wrap(buildAwsValue())
}
object GetHlsStreamingSessionUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        playbackMode.map(value => value),
        hlsFragmentSelector.map(value => value.asEditable),
        containerFormat.map(value => value),
        discontinuityMode.map(value => value),
        displayFragmentTimestamp.map(value => value),
        expires.map(value => value),
        maxMediaPlaylistFragmentResults.map(value => value)
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def playbackMode
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode]
    def hlsFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly
    ]
    def containerFormat
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat]
    def discontinuityMode
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode]
    def displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp
    ]
    def expires: Optional[Expires]
    def maxMediaPlaylistFragmentResults: Optional[HLSMaxResults]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getPlaybackMode: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode
    ] = AwsError.unwrapOptionField("playbackMode", playbackMode)
    def getHlsFragmentSelector: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly
    ] = AwsError.unwrapOptionField("hlsFragmentSelector", hlsFragmentSelector)
    def getContainerFormat: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat
    ] = AwsError.unwrapOptionField("containerFormat", containerFormat)
    def getDiscontinuityMode: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode
    ] = AwsError.unwrapOptionField("discontinuityMode", discontinuityMode)
    def getDisplayFragmentTimestamp: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp
    ] = AwsError.unwrapOptionField(
      "displayFragmentTimestamp",
      displayFragmentTimestamp
    )
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getMaxMediaPlaylistFragmentResults: ZIO[Any, AwsError, HLSMaxResults] =
      AwsError.unwrapOptionField(
        "maxMediaPlaylistFragmentResults",
        maxMediaPlaylistFragmentResults
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val playbackMode
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playbackMode())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode.wrap(value)
        )
    override val hlsFragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsFragmentSelector())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.wrap(value)
      )
    override val containerFormat
        : Optional[zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerFormat())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat.wrap(value)
        )
    override val discontinuityMode: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.discontinuityMode())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode.wrap(value)
      )
    override val displayFragmentTimestamp: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.displayFragmentTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp
          .wrap(value)
      )
    override val expires: Optional[Expires] = zio.aws.core.internal
      .optionalFromNullable(impl.expires())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Expires(value)
      )
    override val maxMediaPlaylistFragmentResults: Optional[HLSMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxMediaPlaylistFragmentResults())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .HLSMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest.ReadOnly =
    new Wrapper(impl)
}
