package zio.aws.kinesisvideoarchivedmedia.model
import scala.jdk.CollectionConverters.*
sealed trait DASHPlaybackMode {
  def unwrap: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode
}
object DASHPlaybackMode {
  def wrap(
      value: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode
  ): zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode = value match {
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.LIVE =>
      val r = LIVE
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.LIVE_REPLAY =>
      val r = LIVE_REPLAY
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.ON_DEMAND =>
      val r = ON_DEMAND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LIVE
      extends zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.LIVE
  }
  case object LIVE_REPLAY
      extends zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.LIVE_REPLAY
  }
  case object ON_DEMAND
      extends zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode.ON_DEMAND
  }
}
