package zio.aws.kinesisvideoarchivedmedia.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerFormat {
  def unwrap: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat
}
object ContainerFormat {
  def wrap(
      value: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat
  ): zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat = value match {
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.FRAGMENTED_MP4 =>
      val r = FRAGMENTED_MP4
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.MPEG_TS =>
      val r = MPEG_TS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object FRAGMENTED_MP4
      extends zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.FRAGMENTED_MP4
  }
  case object MPEG_TS
      extends zio.aws.kinesisvideoarchivedmedia.model.ContainerFormat {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat.MPEG_TS
  }
}
