package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  Timestamp,
  FragmentNumberString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Fragment(
    fragmentNumber: Option[FragmentNumberString] = None,
    fragmentSizeInBytes: Option[Long] = None,
    producerTimestamp: Option[Timestamp] = None,
    serverTimestamp: Option[Timestamp] = None,
    fragmentLengthInMilliseconds: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment = {
    import Fragment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
      .builder()
      .optionallyWith(
        fragmentNumber.map(value =>
          FragmentNumberString.unwrap(value): java.lang.String
        )
      )(_.fragmentNumber)
      .optionallyWith(fragmentSizeInBytes.map(value => value: java.lang.Long))(
        _.fragmentSizeInBytes
      )
      .optionallyWith(
        producerTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.producerTimestamp)
      .optionallyWith(
        serverTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.serverTimestamp)
      .optionallyWith(
        fragmentLengthInMilliseconds.map(value => value: java.lang.Long)
      )(_.fragmentLengthInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.Fragment.wrap(buildAwsValue())
}
object Fragment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.Fragment =
      zio.aws.kinesisvideoarchivedmedia.model.Fragment(
        fragmentNumber.map(value => value),
        fragmentSizeInBytes.map(value => value),
        producerTimestamp.map(value => value),
        serverTimestamp.map(value => value),
        fragmentLengthInMilliseconds.map(value => value)
      )
    def fragmentNumber: Option[FragmentNumberString]
    def fragmentSizeInBytes: Option[Long]
    def producerTimestamp: Option[Timestamp]
    def serverTimestamp: Option[Timestamp]
    def fragmentLengthInMilliseconds: Option[Long]
    def getFragmentNumber: ZIO[Any, AwsError, FragmentNumberString] =
      AwsError.unwrapOptionField("fragmentNumber", fragmentNumber)
    def getFragmentSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fragmentSizeInBytes", fragmentSizeInBytes)
    def getProducerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("producerTimestamp", producerTimestamp)
    def getServerTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serverTimestamp", serverTimestamp)
    def getFragmentLengthInMilliseconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "fragmentLengthInMilliseconds",
        fragmentLengthInMilliseconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ) extends zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly {
    override val fragmentNumber: Option[FragmentNumberString] = scala
      .Option(impl.fragmentNumber())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives
          .FragmentNumberString(value)
      )
    override val fragmentSizeInBytes: Option[Long] =
      scala.Option(impl.fragmentSizeInBytes()).map(value => value: Long)
    override val producerTimestamp: Option[Timestamp] = scala
      .Option(impl.producerTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val serverTimestamp: Option[Timestamp] = scala
      .Option(impl.serverTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val fragmentLengthInMilliseconds: Option[Long] = scala
      .Option(impl.fragmentLengthInMilliseconds())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment
  ): zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly = new Wrapper(
    impl
  )
}
