package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DASHTimestampRange(
    startTimestamp: Option[Timestamp] = None,
    endTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange = {
    import DASHTimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
      .builder()
      .optionallyWith(
        startTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange
      .wrap(buildAwsValue())
}
object DASHTimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange =
      zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange(
        startTimestamp.map(value => value),
        endTimestamp.map(value => value)
      )
    def startTimestamp: Option[Timestamp]
    def endTimestamp: Option[Timestamp]
    def getStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ) extends zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly {
    override val startTimestamp: Option[Timestamp] = scala
      .Option(impl.startTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val endTimestamp: Option[Timestamp] = scala
      .Option(impl.endTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHTimestampRange
  ): zio.aws.kinesisvideoarchivedmedia.model.DASHTimestampRange.ReadOnly =
    new Wrapper(impl)
}
