package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.ContentType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetMediaForFragmentListResponse(
    contentType: Option[ContentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse = {
    import GetMediaForFragmentListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
      .builder()
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
      .wrap(buildAwsValue())
}
object GetMediaForFragmentListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse =
      zio.aws.kinesisvideoarchivedmedia.model
        .GetMediaForFragmentListResponse(contentType.map(value => value))
    def contentType: Option[ContentType]
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly {
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ContentType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly =
    new Wrapper(impl)
}
