package zio.aws.kinesisvideoarchivedmedia
import zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.kinesisvideoarchivedmedia.model.{
  GetClipRequest,
  GetMediaForFragmentListRequest,
  GetDashStreamingSessionUrlRequest,
  ListFragmentsRequest,
  GetHlsStreamingSessionUrlRequest
}
import zio.stream.ZStream
object KinesisVideoArchivedMediaMock extends Mock[KinesisVideoArchivedMedia] {
  object GetMediaForFragmentList
      extends Effect[
        GetMediaForFragmentListRequest,
        AwsError,
        StreamingOutputResult[Any, ReadOnly, Byte]
      ]
  object GetHLSStreamingSessionURL
      extends Effect[
        GetHlsStreamingSessionUrlRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
      ]
  object GetDASHStreamingSessionURL
      extends Effect[
        GetDashStreamingSessionUrlRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
      ]
  object GetClip
      extends Effect[GetClipRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
        Byte
      ]]
  object ListFragments
      extends Stream[
        ListFragmentsRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
      ]
  object ListFragmentsPaginated
      extends Effect[
        ListFragmentsRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, KinesisVideoArchivedMedia] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new KinesisVideoArchivedMedia {
          val api: KinesisVideoArchivedMediaAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : KinesisVideoArchivedMedia = this
          def getMediaForFragmentList(
              request: GetMediaForFragmentListRequest
          ): IO[AwsError, StreamingOutputResult[Any, ReadOnly, Byte]] =
            proxy(GetMediaForFragmentList, request)
          def getHLSStreamingSessionURL(
              request: GetHlsStreamingSessionUrlRequest
          ): IO[
            AwsError,
            zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
          ] = proxy(GetHLSStreamingSessionURL, request)
          def getDASHStreamingSessionURL(
              request: GetDashStreamingSessionUrlRequest
          ): IO[
            AwsError,
            zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
          ] = proxy(GetDASHStreamingSessionURL, request)
          def getClip(
              request: GetClipRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
            Byte
          ]] = proxy(GetClip, request)
          def listFragments(request: ListFragmentsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
          ] = rts.unsafeRun(proxy(ListFragments, request))
          def listFragmentsPaginated(request: ListFragmentsRequest): IO[
            AwsError,
            zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
          ] = proxy(ListFragmentsPaginated, request)
        }
      }
    }
    .toLayer
}
