package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class HLSTimestampRange(
    startTimestamp: Option[Timestamp] = None,
    endTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange = {
    import HLSTimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange
      .builder()
      .optionallyWith(
        startTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(
        endTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange
      .wrap(buildAwsValue())
}
object HLSTimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange =
      zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange(
        startTimestamp.map(value => value),
        endTimestamp.map(value => value)
      )
    def startTimestamp: Option[Timestamp]
    def endTimestamp: Option[Timestamp]
    def getStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getEndTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimestamp", endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange
  ) extends zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly {
    override val startTimestamp: Option[Timestamp] = scala
      .Option(impl.startTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
    override val endTimestamp: Option[Timestamp] = scala
      .Option(impl.endTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSTimestampRange
  ): zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly =
    new Wrapper(impl)
}
