package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  FragmentNumberString,
  ResourceARN,
  StreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMediaForFragmentListRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    fragments: Iterable[FragmentNumberString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest = {
    import GetMediaForFragmentListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .fragments(fragments.map { item =>
        FragmentNumberString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
      .wrap(buildAwsValue())
}
object GetMediaForFragmentListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        fragments
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def fragments: List[FragmentNumberString]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getFragments: ZIO[Any, Nothing, List[FragmentNumberString]] =
      ZIO.succeed(fragments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val fragments: List[FragmentNumberString] = impl
      .fragments()
      .asScala
      .map { item =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives
          .FragmentNumberString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest.ReadOnly =
    new Wrapper(impl)
}
