package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetImagesResponse(
    images: Optional[Iterable[zio.aws.kinesisvideoarchivedmedia.model.Image]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse = {
    import GetImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse
      .wrap(buildAwsValue())
}
object GetImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse =
      zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images
        : Optional[List[zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getImages: ZIO[Any, AwsError, List[
      zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
    ]] = AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly {
    override val images: Optional[
      List[zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.images())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisvideoarchivedmedia.model.Image.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly =
    new Wrapper(impl)
}
