package zio.aws.kinesisvideoarchivedmedia.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  SamplingInterval,
  NextToken,
  StreamName,
  WidthPixels,
  Timestamp,
  HeightPixels,
  FormatConfigValue,
  GetImagesMaxResults,
  ResourceARN
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetImagesRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    imageSelectorType: zio.aws.kinesisvideoarchivedmedia.model.ImageSelectorType,
    startTimestamp: Timestamp,
    endTimestamp: Timestamp,
    samplingInterval: Optional[SamplingInterval] = Optional.Absent,
    format: zio.aws.kinesisvideoarchivedmedia.model.Format,
    formatConfig: Optional[Map[
      zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey,
      FormatConfigValue
    ]] = Optional.Absent,
    widthPixels: Optional[WidthPixels] = Optional.Absent,
    heightPixels: Optional[HeightPixels] = Optional.Absent,
    maxResults: Optional[GetImagesMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest = {
    import GetImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .imageSelectorType(imageSelectorType.unwrap)
      .startTimestamp(Timestamp.unwrap(startTimestamp): Instant)
      .endTimestamp(Timestamp.unwrap(endTimestamp): Instant)
      .optionallyWith(
        samplingInterval.map(value => SamplingInterval.unwrap(value): Integer)
      )(_.samplingInterval)
      .format(format.unwrap)
      .optionallyWith(
        formatConfig.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (FormatConfigValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.formatConfigWithStrings)
      .optionallyWith(
        widthPixels.map(value => WidthPixels.unwrap(value): Integer)
      )(_.widthPixels)
      .optionallyWith(
        heightPixels.map(value => HeightPixels.unwrap(value): Integer)
      )(_.heightPixels)
      .optionallyWith(
        maxResults.map(value =>
          GetImagesMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest
      .wrap(buildAwsValue())
}
object GetImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        imageSelectorType,
        startTimestamp,
        endTimestamp,
        samplingInterval.map(value => value),
        format,
        formatConfig.map(value => value),
        widthPixels.map(value => value),
        heightPixels.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def imageSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.ImageSelectorType
    def startTimestamp: Timestamp
    def endTimestamp: Timestamp
    def samplingInterval: Optional[SamplingInterval]
    def format: zio.aws.kinesisvideoarchivedmedia.model.Format
    def formatConfig: Optional[Map[
      zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey,
      FormatConfigValue
    ]]
    def widthPixels: Optional[WidthPixels]
    def heightPixels: Optional[HeightPixels]
    def maxResults: Optional[GetImagesMaxResults]
    def nextToken: Optional[NextToken]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getImageSelectorType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.ImageSelectorType
    ] = ZIO.succeed(imageSelectorType)
    def getStartTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startTimestamp)
    def getEndTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(endTimestamp)
    def getSamplingInterval: ZIO[Any, AwsError, SamplingInterval] =
      AwsError.unwrapOptionField("samplingInterval", samplingInterval)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.kinesisvideoarchivedmedia.model.Format] =
      ZIO.succeed(format)
    def getFormatConfig: ZIO[Any, AwsError, Map[
      zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey,
      FormatConfigValue
    ]] = AwsError.unwrapOptionField("formatConfig", formatConfig)
    def getWidthPixels: ZIO[Any, AwsError, WidthPixels] =
      AwsError.unwrapOptionField("widthPixels", widthPixels)
    def getHeightPixels: ZIO[Any, AwsError, HeightPixels] =
      AwsError.unwrapOptionField("heightPixels", heightPixels)
    def getMaxResults: ZIO[Any, AwsError, GetImagesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val imageSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.ImageSelectorType =
      zio.aws.kinesisvideoarchivedmedia.model.ImageSelectorType
        .wrap(impl.imageSelectorType())
    override val startTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.startTimestamp())
    override val endTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.endTimestamp())
    override val samplingInterval: Optional[SamplingInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.samplingInterval())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .SamplingInterval(value)
        )
    override val format: zio.aws.kinesisvideoarchivedmedia.model.Format =
      zio.aws.kinesisvideoarchivedmedia.model.Format.wrap(impl.format())
    override val formatConfig: Optional[Map[
      zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey,
      FormatConfigValue
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.formatConfig())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.kinesisvideoarchivedmedia.model.FormatConfigKey
              .wrap(key) -> zio.aws.kinesisvideoarchivedmedia.model.primitives
              .FormatConfigValue(value)
          })
          .toMap
      )
    override val widthPixels: Optional[WidthPixels] = zio.aws.core.internal
      .optionalFromNullable(impl.widthPixels())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.WidthPixels(value)
      )
    override val heightPixels: Optional[HeightPixels] = zio.aws.core.internal
      .optionalFromNullable(impl.heightPixels())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.HeightPixels(value)
      )
    override val maxResults: Optional[GetImagesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .GetImagesMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetImagesRequest.ReadOnly =
    new Wrapper(impl)
}
