package zio.aws.kinesisvideoarchivedmedia.model
import scala.jdk.CollectionConverters._
sealed trait ImageError {
  def unwrap: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError
}
object ImageError {
  def wrap(
      value: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError
  ): zio.aws.kinesisvideoarchivedmedia.model.ImageError = value match {
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.NO_MEDIA =>
      val r = NO_MEDIA
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.MEDIA_ERROR =>
      val r = MEDIA_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisvideoarchivedmedia.model.ImageError {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_MEDIA
      extends zio.aws.kinesisvideoarchivedmedia.model.ImageError {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.NO_MEDIA
  }
  case object MEDIA_ERROR
      extends zio.aws.kinesisvideoarchivedmedia.model.ImageError {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError.MEDIA_ERROR
  }
}
