package zio.aws.kinesisvideoarchivedmedia.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ClipFragmentSelector(
    fragmentSelectorType: zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType,
    timestampRange: zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector = {
    import ClipFragmentSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector
      .builder()
      .fragmentSelectorType(fragmentSelectorType.unwrap)
      .timestampRange(timestampRange.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector
      .wrap(buildAwsValue())
}
object ClipFragmentSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector =
      zio.aws.kinesisvideoarchivedmedia.model
        .ClipFragmentSelector(fragmentSelectorType, timestampRange.asEditable)
    def fragmentSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType
    def timestampRange
        : zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly
    def getFragmentSelectorType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType
    ] = ZIO.succeed(fragmentSelectorType)
    def getTimestampRange: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly
    ] = ZIO.succeed(timestampRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector
  ) extends zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly {
    override val fragmentSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType =
      zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelectorType
        .wrap(impl.fragmentSelectorType())
    override val timestampRange
        : zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange.ReadOnly =
      zio.aws.kinesisvideoarchivedmedia.model.ClipTimestampRange
        .wrap(impl.timestampRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector
  ): zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly =
    new Wrapper(impl)
}
