package zio.aws.kinesisvideoarchivedmedia
import zio.aws.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse.ReadOnly
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.kinesisvideoarchivedmedia.model.{
  GetClipRequest,
  GetMediaForFragmentListRequest,
  GetDashStreamingSessionUrlRequest,
  ListFragmentsRequest,
  GetHlsStreamingSessionUrlRequest,
  GetImagesRequest
}
import zio.stream.ZStream
object KinesisVideoArchivedMediaMock extends Mock[KinesisVideoArchivedMedia] {
  object GetMediaForFragmentList
      extends Effect[
        GetMediaForFragmentListRequest,
        AwsError,
        StreamingOutputResult[Any, ReadOnly, Byte]
      ]
  object GetHLSStreamingSessionURL
      extends Effect[
        GetHlsStreamingSessionUrlRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
      ]
  object GetDASHStreamingSessionURL
      extends Effect[
        GetDashStreamingSessionUrlRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
      ]
  object GetClip
      extends Effect[GetClipRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
        Byte
      ]]
  object GetImages
      extends Stream[
        GetImagesRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
      ]
  object GetImagesPaginated
      extends Effect[
        GetImagesRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly
      ]
  object ListFragments
      extends Stream[
        ListFragmentsRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
      ]
  object ListFragmentsPaginated
      extends Effect[
        ListFragmentsRequest,
        AwsError,
        zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, KinesisVideoArchivedMedia] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, KinesisVideoArchivedMedia] { rts =>
        zio.ZIO.succeed {
          new KinesisVideoArchivedMedia {
            val api: KinesisVideoArchivedMediaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): KinesisVideoArchivedMedia = this
            def getMediaForFragmentList(
                request: GetMediaForFragmentListRequest
            ): IO[AwsError, StreamingOutputResult[Any, ReadOnly, Byte]] =
              proxy(GetMediaForFragmentList, request)
            def getHLSStreamingSessionURL(
                request: GetHlsStreamingSessionUrlRequest
            ): IO[
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse.ReadOnly
            ] = proxy(GetHLSStreamingSessionURL, request)
            def getDASHStreamingSessionURL(
                request: GetDashStreamingSessionUrlRequest
            ): IO[
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly
            ] = proxy(GetDASHStreamingSessionURL, request)
            def getClip(
                request: GetClipRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.kinesisvideoarchivedmedia.model.GetClipResponse.ReadOnly,
              Byte
            ]] = proxy(GetClip, request)
            def getImages(request: GetImagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.Image.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def getImagesPaginated(request: GetImagesRequest): IO[
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.GetImagesResponse.ReadOnly
            ] = proxy(GetImagesPaginated, request)
            def listFragments(request: ListFragmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.Fragment.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFragments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFragmentsPaginated(request: ListFragmentsRequest): IO[
              AwsError,
              zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsResponse.ReadOnly
            ] = proxy(ListFragmentsPaginated, request)
          }
        }
      }
    }
  }
}
