package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  ResourceARN,
  StreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetClipRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    clipFragmentSelector: zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest = {
    import GetClipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .clipFragmentSelector(clipFragmentSelector.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest.wrap(buildAwsValue())
}
object GetClipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        clipFragmentSelector.asEditable
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def clipFragmentSelector
        : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getClipFragmentSelector: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly
    ] = ZIO.succeed(clipFragmentSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val clipFragmentSelector
        : zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector.ReadOnly =
      zio.aws.kinesisvideoarchivedmedia.model.ClipFragmentSelector
        .wrap(impl.clipFragmentSelector())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetClipRequest.ReadOnly =
    new Wrapper(impl)
}
