package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  NextToken,
  ListFragmentsMaxResults,
  ResourceARN,
  StreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFragmentsRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[ResourceARN] = Optional.Absent,
    maxResults: Optional[ListFragmentsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    fragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest = {
    import ListFragmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(
        maxResults.map(value =>
          ListFragmentsMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(fragmentSelector.map(value => value.buildAwsValue()))(
        _.fragmentSelector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
      .wrap(buildAwsValue())
}
object ListFragmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest =
      zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        fragmentSelector.map(value => value.asEditable)
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[ResourceARN]
    def maxResults: Optional[ListFragmentsMaxResults]
    def nextToken: Optional[NextToken]
    def fragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getMaxResults: ZIO[Any, AwsError, ListFragmentsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFragmentSelector: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ] = AwsError.unwrapOptionField("fragmentSelector", fragmentSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val maxResults: Optional[ListFragmentsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .ListFragmentsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken(value)
      )
    override val fragmentSelector: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fragmentSelector())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly =
    new Wrapper(impl)
}
