package zio.aws.kinesisvideoarchivedmedia.model
import scala.jdk.CollectionConverters._
sealed trait HLSPlaybackMode {
  def unwrap: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode
}
object HLSPlaybackMode {
  def wrap(
      value: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode
  ): zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode = value match {
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.LIVE =>
      val r = LIVE
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.LIVE_REPLAY =>
      val r = LIVE_REPLAY
      r
    case software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.ON_DEMAND =>
      val r = ON_DEMAND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LIVE
      extends zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.LIVE
  }
  case object LIVE_REPLAY
      extends zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.LIVE_REPLAY
  }
  case object ON_DEMAND
      extends zio.aws.kinesisvideoarchivedmedia.model.HLSPlaybackMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode =
      software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode.ON_DEMAND
  }
}
