package zio.aws.kinesisvideoarchivedmedia.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HLSFragmentSelector(
    fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType
    ] = Optional.Absent,
    timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector = {
    import HLSFragmentSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector
      .builder()
      .optionallyWith(fragmentSelectorType.map(value => value.unwrap))(
        _.fragmentSelectorType
      )
      .optionallyWith(timestampRange.map(value => value.buildAwsValue()))(
        _.timestampRange
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector
      .wrap(buildAwsValue())
}
object HLSFragmentSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector =
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector(
        fragmentSelectorType.map(value => value),
        timestampRange.map(value => value.asEditable)
      )
    def fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType
    ]
    def timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly
    ]
    def getFragmentSelectorType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType
    ] = AwsError.unwrapOptionField("fragmentSelectorType", fragmentSelectorType)
    def getTimestampRange: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly
    ] = AwsError.unwrapOptionField("timestampRange", timestampRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector
  ) extends zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly {
    override val fragmentSelectorType: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fragmentSelectorType())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelectorType
          .wrap(value)
      )
    override val timestampRange: Optional[
      zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestampRange())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.HLSTimestampRange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector
  ): zio.aws.kinesisvideoarchivedmedia.model.HLSFragmentSelector.ReadOnly =
    new Wrapper(impl)
}
