package zio.aws.kinesisvideoarchivedmedia.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FragmentSelector(
    fragmentSelectorType: zio.aws.kinesisvideoarchivedmedia.model.FragmentSelectorType,
    timestampRange: zio.aws.kinesisvideoarchivedmedia.model.TimestampRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector = {
    import FragmentSelector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector
      .builder()
      .fragmentSelectorType(fragmentSelectorType.unwrap)
      .timestampRange(timestampRange.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector
      .wrap(buildAwsValue())
}
object FragmentSelector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector =
      zio.aws.kinesisvideoarchivedmedia.model
        .FragmentSelector(fragmentSelectorType, timestampRange.asEditable)
    def fragmentSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.FragmentSelectorType
    def timestampRange
        : zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly
    def getFragmentSelectorType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelectorType
    ] = ZIO.succeed(fragmentSelectorType)
    def getTimestampRange: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly
    ] = ZIO.succeed(timestampRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector
  ) extends zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly {
    override val fragmentSelectorType
        : zio.aws.kinesisvideoarchivedmedia.model.FragmentSelectorType =
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelectorType
        .wrap(impl.fragmentSelectorType())
    override val timestampRange
        : zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly =
      zio.aws.kinesisvideoarchivedmedia.model.TimestampRange
        .wrap(impl.timestampRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector
  ): zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly =
    new Wrapper(impl)
}
