package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.DASHStreamingSessionURL
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDashStreamingSessionUrlResponse(
    dashStreamingSessionURL: Option[DASHStreamingSessionURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse = {
    import GetDashStreamingSessionUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse
      .builder()
      .optionallyWith(
        dashStreamingSessionURL.map(value =>
          DASHStreamingSessionURL.unwrap(value): java.lang.String
        )
      )(_.dashStreamingSessionURL)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse
      .wrap(buildAwsValue())
}
object GetDashStreamingSessionUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse =
      zio.aws.kinesisvideoarchivedmedia.model
        .GetDashStreamingSessionUrlResponse(
          dashStreamingSessionURL.map(value => value)
        )
    def dashStreamingSessionURL: Option[DASHStreamingSessionURL]
    def getDashStreamingSessionURL
        : ZIO[Any, AwsError, DASHStreamingSessionURL] = AwsError
      .unwrapOptionField("dashStreamingSessionURL", dashStreamingSessionURL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly {
    override val dashStreamingSessionURL: Option[DASHStreamingSessionURL] =
      scala
        .Option(impl.dashStreamingSessionURL())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.primitives
            .DASHStreamingSessionURL(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse
  ): zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse.ReadOnly =
    new Wrapper(impl)
}
