package zio.aws.kinesisvideoarchivedmedia.model
import java.lang.Integer
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  DASHMaxResults,
  Expires,
  ResourceARN,
  StreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetDashStreamingSessionUrlRequest(
    streamName: Option[StreamName] = None,
    streamARN: Option[ResourceARN] = None,
    playbackMode: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode
    ] = None,
    displayFragmentTimestamp: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = None,
    displayFragmentNumber: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] = None,
    dashFragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector
    ] = None,
    expires: Option[Expires] = None,
    maxManifestFragmentResults: Option[DASHMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest = {
    import GetDashStreamingSessionUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(playbackMode.map(value => value.unwrap))(_.playbackMode)
      .optionallyWith(displayFragmentTimestamp.map(value => value.unwrap))(
        _.displayFragmentTimestamp
      )
      .optionallyWith(displayFragmentNumber.map(value => value.unwrap))(
        _.displayFragmentNumber
      )
      .optionallyWith(dashFragmentSelector.map(value => value.buildAwsValue()))(
        _.dashFragmentSelector
      )
      .optionallyWith(expires.map(value => Expires.unwrap(value): Integer))(
        _.expires
      )
      .optionallyWith(
        maxManifestFragmentResults.map(value =>
          DASHMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxManifestFragmentResults)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
      .wrap(buildAwsValue())
}
object GetDashStreamingSessionUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest =
      zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        playbackMode.map(value => value),
        displayFragmentTimestamp.map(value => value),
        displayFragmentNumber.map(value => value),
        dashFragmentSelector.map(value => value.asEditable),
        expires.map(value => value),
        maxManifestFragmentResults.map(value => value)
      )
    def streamName: Option[StreamName]
    def streamARN: Option[ResourceARN]
    def playbackMode
        : Option[zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode]
    def displayFragmentTimestamp: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ]
    def displayFragmentNumber: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ]
    def dashFragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ]
    def expires: Option[Expires]
    def maxManifestFragmentResults: Option[DASHMaxResults]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getPlaybackMode: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode
    ] = AwsError.unwrapOptionField("playbackMode", playbackMode)
    def getDisplayFragmentTimestamp: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = AwsError.unwrapOptionField(
      "displayFragmentTimestamp",
      displayFragmentTimestamp
    )
    def getDisplayFragmentNumber: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] =
      AwsError.unwrapOptionField("displayFragmentNumber", displayFragmentNumber)
    def getDashFragmentSelector: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ] = AwsError.unwrapOptionField("dashFragmentSelector", dashFragmentSelector)
    def getExpires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expires)
    def getMaxManifestFragmentResults: ZIO[Any, AwsError, DASHMaxResults] =
      AwsError.unwrapOptionField(
        "maxManifestFragmentResults",
        maxManifestFragmentResults
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly {
    override val streamName: Option[StreamName] = scala
      .Option(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Option[ResourceARN] = scala
      .Option(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val playbackMode
        : Option[zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode] =
      scala
        .Option(impl.playbackMode())
        .map(value =>
          zio.aws.kinesisvideoarchivedmedia.model.DASHPlaybackMode.wrap(value)
        )
    override val displayFragmentTimestamp: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
    ] = scala
      .Option(impl.displayFragmentTimestamp())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp
          .wrap(value)
      )
    override val displayFragmentNumber: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
    ] = scala
      .Option(impl.displayFragmentNumber())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber
          .wrap(value)
      )
    override val dashFragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.ReadOnly
    ] = scala
      .Option(impl.dashFragmentSelector())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.DASHFragmentSelector.wrap(value)
      )
    override val expires: Option[Expires] = scala
      .Option(impl.expires())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.Expires(value)
      )
    override val maxManifestFragmentResults: Option[DASHMaxResults] = scala
      .Option(impl.maxManifestFragmentResults())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.DASHMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest.ReadOnly =
    new Wrapper(impl)
}
