package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.{
  NextToken,
  ListFragmentsMaxResults,
  ResourceARN,
  StreamName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFragmentsRequest(
    streamName: Option[StreamName] = None,
    streamARN: Option[ResourceARN] = None,
    maxResults: Option[ListFragmentsMaxResults] = None,
    nextToken: Option[NextToken] = None,
    fragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest = {
    import ListFragmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .optionallyWith(
        maxResults.map(value =>
          ListFragmentsMaxResults.unwrap(value): java.lang.Long
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(fragmentSelector.map(value => value.buildAwsValue()))(
        _.fragmentSelector
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest
      .wrap(buildAwsValue())
}
object ListFragmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest =
      zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest(
        streamName.map(value => value),
        streamARN.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        fragmentSelector.map(value => value.asEditable)
      )
    def streamName: Option[StreamName]
    def streamARN: Option[ResourceARN]
    def maxResults: Option[ListFragmentsMaxResults]
    def nextToken: Option[NextToken]
    def fragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
    def getMaxResults: ZIO[Any, AwsError, ListFragmentsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFragmentSelector: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ] = AwsError.unwrapOptionField("fragmentSelector", fragmentSelector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ) extends zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly {
    override val streamName: Option[StreamName] = scala
      .Option(impl.streamName())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.StreamName(value)
      )
    override val streamARN: Option[ResourceARN] = scala
      .Option(impl.streamARN())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.ResourceARN(value)
      )
    override val maxResults: Option[ListFragmentsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives
          .ListFragmentsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.primitives.NextToken(value)
      )
    override val fragmentSelector: Option[
      zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.ReadOnly
    ] = scala
      .Option(impl.fragmentSelector())
      .map(value =>
        zio.aws.kinesisvideoarchivedmedia.model.FragmentSelector.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest
  ): zio.aws.kinesisvideoarchivedmedia.model.ListFragmentsRequest.ReadOnly =
    new Wrapper(impl)
}
