package zio.aws.kinesisvideoarchivedmedia.model
import zio.aws.kinesisvideoarchivedmedia.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimestampRange(
    startTimestamp: Timestamp,
    endTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange = {
    import TimestampRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange
      .builder()
      .startTimestamp(Timestamp.unwrap(startTimestamp): Instant)
      .endTimestamp(Timestamp.unwrap(endTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly =
    zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.wrap(buildAwsValue())
}
object TimestampRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisvideoarchivedmedia.model.TimestampRange =
      zio.aws.kinesisvideoarchivedmedia.model
        .TimestampRange(startTimestamp, endTimestamp)
    def startTimestamp: Timestamp
    def endTimestamp: Timestamp
    def getStartTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(startTimestamp)
    def getEndTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(endTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange
  ) extends zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly {
    override val startTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.startTimestamp())
    override val endTimestamp: Timestamp =
      zio.aws.kinesisvideoarchivedmedia.model.primitives
        .Timestamp(impl.endTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange
  ): zio.aws.kinesisvideoarchivedmedia.model.TimestampRange.ReadOnly =
    new Wrapper(impl)
}
