package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.InputParallelismCount
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InputParallelismUpdate(countUpdate: InputParallelismCount) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelismUpdate = {
    import InputParallelismUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelismUpdate
      .builder()
      .countUpdate(InputParallelismCount.unwrap(countUpdate): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate
      .wrap(buildAwsValue())
}
object InputParallelismUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelismUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate =
      zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate(countUpdate)
    def countUpdate: InputParallelismCount
    def getCountUpdate: ZIO[Any, Nothing, InputParallelismCount] =
      ZIO.succeed(countUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelismUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate.ReadOnly {
    override val countUpdate: InputParallelismCount =
      zio.aws.kinesisanalyticsv2.model.primitives
        .InputParallelismCount(impl.countUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelismUpdate
  ): zio.aws.kinesisanalyticsv2.model.InputParallelismUpdate.ReadOnly =
    new Wrapper(impl)
}
