package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  RecordColumnDelimiter,
  RecordRowDelimiter
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CSVMappingParameters(
    recordRowDelimiter: RecordRowDelimiter,
    recordColumnDelimiter: RecordColumnDelimiter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters = {
    import CSVMappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters
      .builder()
      .recordRowDelimiter(
        RecordRowDelimiter.unwrap(recordRowDelimiter): java.lang.String
      )
      .recordColumnDelimiter(
        RecordColumnDelimiter.unwrap(recordColumnDelimiter): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.wrap(buildAwsValue())
}
object CSVMappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CSVMappingParameters =
      zio.aws.kinesisanalyticsv2.model
        .CSVMappingParameters(recordRowDelimiter, recordColumnDelimiter)
    def recordRowDelimiter: RecordRowDelimiter
    def recordColumnDelimiter: RecordColumnDelimiter
    def getRecordRowDelimiter: ZIO[Any, Nothing, RecordRowDelimiter] =
      ZIO.succeed(recordRowDelimiter)
    def getRecordColumnDelimiter: ZIO[Any, Nothing, RecordColumnDelimiter] =
      ZIO.succeed(recordColumnDelimiter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters
  ) extends zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly {
    override val recordRowDelimiter: RecordRowDelimiter =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RecordRowDelimiter(impl.recordRowDelimiter())
    override val recordColumnDelimiter: RecordColumnDelimiter =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RecordColumnDelimiter(impl.recordColumnDelimiter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters
  ): zio.aws.kinesisanalyticsv2.model.CSVMappingParameters.ReadOnly =
    new Wrapper(impl)
}
