package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddApplicationInputProcessingConfigurationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    inputId: Id,
    inputProcessingConfiguration: zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest = {
    import AddApplicationInputProcessingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .inputId(Id.unwrap(inputId): java.lang.String)
      .inputProcessingConfiguration(
        inputProcessingConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
      .wrap(buildAwsValue())
}
object AddApplicationInputProcessingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationInputProcessingConfigurationRequest(
          applicationName,
          currentApplicationVersionId,
          inputId,
          inputProcessingConfiguration.asEditable
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def inputId: Id
    def inputProcessingConfiguration
        : zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getInputId: ZIO[Any, Nothing, Id] = ZIO.succeed(inputId)
    def getInputProcessingConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = ZIO.succeed(inputProcessingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val inputId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.inputId())
    override val inputProcessingConfiguration
        : zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
        .wrap(impl.inputProcessingConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
