package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationCodeConfigurationUpdate(
    codeContentTypeUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CodeContentType
    ] = Optional.Absent,
    codeContentUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate = {
    import ApplicationCodeConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
      .builder()
      .optionallyWith(codeContentTypeUpdate.map(value => value.unwrap))(
        _.codeContentTypeUpdate
      )
      .optionallyWith(codeContentUpdate.map(value => value.buildAwsValue()))(
        _.codeContentUpdate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
      .wrap(buildAwsValue())
}
object ApplicationCodeConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate(
        codeContentTypeUpdate.map(value => value),
        codeContentUpdate.map(value => value.asEditable)
      )
    def codeContentTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.CodeContentType]
    def codeContentUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly]
    def getCodeContentTypeUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.CodeContentType] =
      AwsError.unwrapOptionField("codeContentTypeUpdate", codeContentTypeUpdate)
    def getCodeContentUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("codeContentUpdate", codeContentUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly {
    override val codeContentTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.CodeContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeContentTypeUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.CodeContentType.wrap(value)
        )
    override val codeContentUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.codeContentUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
