package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqlApplicationConfigurationDescription(
    inputDescriptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.InputDescription]
    ] = Optional.Absent,
    outputDescriptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.OutputDescription]
    ] = Optional.Absent,
    referenceDataSourceDescriptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription = {
    import SqlApplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
      .builder()
      .optionallyWith(
        inputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDescriptions)
      .optionallyWith(
        outputDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputDescriptions)
      .optionallyWith(
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSourceDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
      .wrap(buildAwsValue())
}
object SqlApplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription(
        inputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSourceDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly]
    ]
    def outputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly]
    ]
    def referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]]
    def getInputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("inputDescriptions", inputDescriptions)
    def getOutputDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("outputDescriptions", outputDescriptions)
    def getReferenceDataSourceDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "referenceDataSourceDescriptions",
      referenceDataSourceDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly {
    override val inputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.InputDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.InputDescription.wrap(item)
        }.toList
      )
    override val outputDescriptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.OutputDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.OutputDescription.wrap(item)
        }.toList
      )
    override val referenceDataSourceDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSourceDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
