package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseOutput(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutput = {
    import KinesisFirehoseOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput.wrap(buildAwsValue())
}
object KinesisFirehoseOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput =
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutput
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutput
  ): zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutput.ReadOnly =
    new Wrapper(impl)
}
