package zio.aws.kinesisanalyticsv2
import zio.aws.kinesisanalyticsv2.model.{
  UpdateApplicationRequest,
  DeleteApplicationCloudWatchLoggingOptionRequest,
  DeleteApplicationRequest,
  AddApplicationOutputRequest,
  StartApplicationRequest,
  AddApplicationReferenceDataSourceRequest,
  DeleteApplicationSnapshotRequest,
  AddApplicationCloudWatchLoggingOptionRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DiscoverInputSchemaRequest,
  DeleteApplicationInputProcessingConfigurationRequest,
  ListApplicationSnapshotsRequest,
  DeleteApplicationVpcConfigurationRequest,
  DescribeApplicationRequest,
  AddApplicationVpcConfigurationRequest,
  UpdateApplicationMaintenanceConfigurationRequest,
  DescribeApplicationVersionRequest,
  RollbackApplicationRequest,
  DescribeApplicationSnapshotRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  AddApplicationInputProcessingConfigurationRequest,
  StopApplicationRequest,
  CreateApplicationSnapshotRequest,
  ListApplicationVersionsRequest,
  DeleteApplicationReferenceDataSourceRequest,
  DeleteApplicationOutputRequest,
  CreateApplicationPresignedUrlRequest,
  TagResourceRequest,
  AddApplicationInputRequest
}
import zio.aws.kinesisanalyticsv2.model.TagResourceResponse.ReadOnly
import software.amazon.awssdk.services.kinesisanalyticsv2.{
  KinesisAnalyticsV2AsyncClientBuilder,
  KinesisAnalyticsV2AsyncClient
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.kinesisanalyticsv2.model.{
  DeleteApplicationOutputResponse,
  AddApplicationReferenceDataSourceResponse,
  DeleteApplicationInputProcessingConfigurationResponse,
  DescribeApplicationResponse,
  UpdateApplicationResponse,
  CreateApplicationPresignedUrlResponse,
  StartApplicationResponse,
  AddApplicationCloudWatchLoggingOptionResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  SnapshotDetails,
  RollbackApplicationResponse,
  ListApplicationsResponse,
  AddApplicationInputProcessingConfigurationResponse,
  DeleteApplicationCloudWatchLoggingOptionResponse,
  ListApplicationVersionsResponse,
  CreateApplicationSnapshotResponse,
  CreateApplicationResponse,
  UpdateApplicationMaintenanceConfigurationResponse,
  AddApplicationVpcConfigurationResponse,
  AddApplicationInputResponse,
  StopApplicationResponse,
  DeleteApplicationReferenceDataSourceResponse,
  DiscoverInputSchemaResponse,
  DescribeApplicationSnapshotResponse,
  DescribeApplicationVersionResponse,
  DeleteApplicationVpcConfigurationResponse,
  ListApplicationSnapshotsResponse,
  TagResourceResponse,
  AddApplicationOutputResponse,
  ApplicationSummary,
  ApplicationVersionSummary,
  DeleteApplicationResponse,
  DeleteApplicationSnapshotResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait KinesisAnalyticsV2 extends AspectSupport[KinesisAnalyticsV2] {
  val api: KinesisAnalyticsV2AsyncClient
  def deleteApplicationSnapshot(request: DeleteApplicationSnapshotRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.ReadOnly
  ]
  def deleteApplication(request: DeleteApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.ReadOnly
  ]
  def createApplicationSnapshot(request: CreateApplicationSnapshotRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.ReadOnly
  ]
  def addApplicationReferenceDataSource(
      request: AddApplicationReferenceDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly
  ]
  def describeApplicationSnapshot(
      request: DescribeApplicationSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly
  ]
  def createApplicationPresignedUrl(
      request: CreateApplicationPresignedUrlRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly
  ]
  def describeApplication(request: DescribeApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly
  ]
  def deleteApplicationOutput(request: DeleteApplicationOutputRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.ReadOnly
  ]
  def createApplication(request: CreateApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly
  ]
  def discoverInputSchema(request: DiscoverInputSchemaRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.ReadOnly
  ]
  def deleteApplicationInputProcessingConfiguration(
      request: DeleteApplicationInputProcessingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
  ]
  def addApplicationCloudWatchLoggingOption(
      request: AddApplicationCloudWatchLoggingOptionRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ]
  def updateApplicationMaintenanceConfiguration(
      request: UpdateApplicationMaintenanceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly
  ]
  def deleteApplicationVpcConfiguration(
      request: DeleteApplicationVpcConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly
  ]
  def addApplicationVpcConfiguration(
      request: AddApplicationVpcConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly
  ]
  def addApplicationOutput(request: AddApplicationOutputRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly
  ]
  def startApplication(request: StartApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.ReadOnly
  ]
  def deleteApplicationCloudWatchLoggingOption(
      request: DeleteApplicationCloudWatchLoggingOptionRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ]
  def describeApplicationVersion(
      request: DescribeApplicationVersionRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly
  ]
  def addApplicationInputProcessingConfiguration(
      request: AddApplicationInputProcessingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.ReadOnly
  ]
  def addApplicationInput(request: AddApplicationInputRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly]
  def listApplications(request: ListApplicationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
  ]
  def listApplicationsPaginated(request: ListApplicationsRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly
  ]
  def listApplicationSnapshots(
      request: ListApplicationSnapshotsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
  ]
  def listApplicationSnapshotsPaginated(
      request: ListApplicationSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly
  ]
  def updateApplication(request: UpdateApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly
  ]
  def listApplicationVersions(request: ListApplicationVersionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
  ]
  def listApplicationVersionsPaginated(
      request: ListApplicationVersionsRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly
  ]
  def deleteApplicationReferenceDataSource(
      request: DeleteApplicationReferenceDataSourceRequest
  ): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
  ]
  def stopApplication(request: StopApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.ReadOnly
  ]
  def rollbackApplication(request: RollbackApplicationRequest): IO[
    AwsError,
    zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly
  ]
}
object KinesisAnalyticsV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, KinesisAnalyticsV2] =
    customized(identity)
  def customized(
      customization: KinesisAnalyticsV2AsyncClientBuilder => KinesisAnalyticsV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, KinesisAnalyticsV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KinesisAnalyticsV2AsyncClientBuilder => KinesisAnalyticsV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, KinesisAnalyticsV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KinesisAnalyticsV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      KinesisAnalyticsV2AsyncClient,
      KinesisAnalyticsV2AsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      KinesisAnalyticsV2AsyncClient,
      KinesisAnalyticsV2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new KinesisAnalyticsV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class KinesisAnalyticsV2Impl[R](
      override val api: KinesisAnalyticsV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends KinesisAnalyticsV2
      with AwsServiceBase[R] {
    override val serviceName: String = "KinesisAnalyticsV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KinesisAnalyticsV2Impl[R1] =
      new KinesisAnalyticsV2Impl(api, newAspect, r)
    def deleteApplicationSnapshot(
        request: DeleteApplicationSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest,
      DeleteApplicationSnapshotResponse
    ]("deleteApplicationSnapshot", api.deleteApplicationSnapshot)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.wrap
    ).provideEnvironment(r)
    def deleteApplication(request: DeleteApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest,
      DeleteApplicationResponse
    ]("deleteApplication", api.deleteApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.wrap)
      .provideEnvironment(r)
    def createApplicationSnapshot(
        request: CreateApplicationSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest,
      CreateApplicationSnapshotResponse
    ]("createApplicationSnapshot", api.createApplicationSnapshot)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.wrap
    ).provideEnvironment(r)
    def addApplicationReferenceDataSource(
        request: AddApplicationReferenceDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest,
      AddApplicationReferenceDataSourceResponse
    ](
      "addApplicationReferenceDataSource",
      api.addApplicationReferenceDataSource
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.wrap
      )
      .provideEnvironment(r)
    def describeApplicationSnapshot(
        request: DescribeApplicationSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest,
      DescribeApplicationSnapshotResponse
    ]("describeApplicationSnapshot", api.describeApplicationSnapshot)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.wrap
    ).provideEnvironment(r)
    def createApplicationPresignedUrl(
        request: CreateApplicationPresignedUrlRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest,
      CreateApplicationPresignedUrlResponse
    ]("createApplicationPresignedUrl", api.createApplicationPresignedUrl)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.wrap
    ).provideEnvironment(r)
    def describeApplication(request: DescribeApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest,
      DescribeApplicationResponse
    ]("describeApplication", api.describeApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationOutput(request: DeleteApplicationOutputRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest,
      DeleteApplicationOutputResponse
    ]("deleteApplicationOutput", api.deleteApplicationOutput)(
      request.buildAwsValue()
    ).map(zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.wrap)
      .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def discoverInputSchema(request: DiscoverInputSchemaRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest,
      DiscoverInputSchemaResponse
    ]("discoverInputSchema", api.discoverInputSchema)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationInputProcessingConfiguration(
        request: DeleteApplicationInputProcessingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest,
      DeleteApplicationInputProcessingConfigurationResponse
    ](
      "deleteApplicationInputProcessingConfiguration",
      api.deleteApplicationInputProcessingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def addApplicationCloudWatchLoggingOption(
        request: AddApplicationCloudWatchLoggingOptionRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest,
      AddApplicationCloudWatchLoggingOptionResponse
    ](
      "addApplicationCloudWatchLoggingOption",
      api.addApplicationCloudWatchLoggingOption
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.wrap
      )
      .provideEnvironment(r)
    def updateApplicationMaintenanceConfiguration(
        request: UpdateApplicationMaintenanceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest,
      UpdateApplicationMaintenanceConfigurationResponse
    ](
      "updateApplicationMaintenanceConfiguration",
      api.updateApplicationMaintenanceConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteApplicationVpcConfiguration(
        request: DeleteApplicationVpcConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest,
      DeleteApplicationVpcConfigurationResponse
    ](
      "deleteApplicationVpcConfiguration",
      api.deleteApplicationVpcConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def addApplicationVpcConfiguration(
        request: AddApplicationVpcConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest,
      AddApplicationVpcConfigurationResponse
    ]("addApplicationVpcConfiguration", api.addApplicationVpcConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.wrap
    ).provideEnvironment(r)
    def addApplicationOutput(request: AddApplicationOutputRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest,
      AddApplicationOutputResponse
    ]("addApplicationOutput", api.addApplicationOutput)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.wrap)
      .provideEnvironment(r)
    def startApplication(request: StartApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest,
      StartApplicationResponse
    ]("startApplication", api.startApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationCloudWatchLoggingOption(
        request: DeleteApplicationCloudWatchLoggingOptionRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest,
      DeleteApplicationCloudWatchLoggingOptionResponse
    ](
      "deleteApplicationCloudWatchLoggingOption",
      api.deleteApplicationCloudWatchLoggingOption
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.wrap
      )
      .provideEnvironment(r)
    def describeApplicationVersion(
        request: DescribeApplicationVersionRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest,
      DescribeApplicationVersionResponse
    ]("describeApplicationVersion", api.describeApplicationVersion)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.wrap
    ).provideEnvironment(r)
    def addApplicationInputProcessingConfiguration(
        request: AddApplicationInputProcessingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest,
      AddApplicationInputProcessingConfigurationResponse
    ](
      "addApplicationInputProcessingConfiguration",
      api.addApplicationInputProcessingConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def addApplicationInput(request: AddApplicationInputRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest,
      AddApplicationInputResponse
    ]("addApplicationInput", api.addApplicationInput)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.kinesisanalyticsv2.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listApplications(request: ListApplicationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationSummary
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.kinesisanalyticsv2.model.ApplicationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationsPaginated(request: ListApplicationsRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest,
      ListApplicationsResponse
    ]("listApplications", api.listApplications)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def listApplicationSnapshots(
        request: ListApplicationSnapshotsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest,
      ListApplicationSnapshotsResponse,
      SnapshotDetails
    ](
      "listApplicationSnapshots",
      api.listApplicationSnapshots,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.snapshotSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.kinesisanalyticsv2.model.SnapshotDetails.wrap(item))
      .provideEnvironment(r)
    def listApplicationSnapshotsPaginated(
        request: ListApplicationSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest,
      ListApplicationSnapshotsResponse
    ]("listApplicationSnapshots", api.listApplicationSnapshots)(
      request.buildAwsValue()
    ).map(
      zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.wrap
    ).provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listApplicationVersions(
        request: ListApplicationVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest,
      ListApplicationVersionsResponse,
      ApplicationVersionSummary
    ](
      "listApplicationVersions",
      api.listApplicationVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applicationVersionSummaries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listApplicationVersionsPaginated(
        request: ListApplicationVersionsRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest,
      ListApplicationVersionsResponse
    ]("listApplicationVersions", api.listApplicationVersions)(
      request.buildAwsValue()
    ).map(zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.wrap)
      .provideEnvironment(r)
    def deleteApplicationReferenceDataSource(
        request: DeleteApplicationReferenceDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest,
      DeleteApplicationReferenceDataSourceResponse
    ](
      "deleteApplicationReferenceDataSource",
      api.deleteApplicationReferenceDataSource
    )(request.buildAwsValue())
      .map(
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.wrap
      )
      .provideEnvironment(r)
    def stopApplication(request: StopApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest,
      StopApplicationResponse
    ]("stopApplication", api.stopApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.wrap)
      .provideEnvironment(r)
    def rollbackApplication(request: RollbackApplicationRequest): IO[
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest,
      RollbackApplicationResponse
    ]("rollbackApplication", api.rollbackApplication)(request.buildAwsValue())
      .map(zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteApplicationSnapshot(request: DeleteApplicationSnapshotRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationSnapshot(request))
  def deleteApplication(request: DeleteApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplication(request))
  def createApplicationSnapshot(request: CreateApplicationSnapshotRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplicationSnapshot(request))
  def addApplicationReferenceDataSource(
      request: AddApplicationReferenceDataSourceRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationReferenceDataSource(request))
  def describeApplicationSnapshot(
      request: DescribeApplicationSnapshotRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationSnapshot(request))
  def createApplicationPresignedUrl(
      request: CreateApplicationPresignedUrlRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplicationPresignedUrl(request))
  def describeApplication(request: DescribeApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplication(request))
  def deleteApplicationOutput(request: DeleteApplicationOutputRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationOutput(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def discoverInputSchema(request: DiscoverInputSchemaRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.discoverInputSchema(request))
  def deleteApplicationInputProcessingConfiguration(
      request: DeleteApplicationInputProcessingConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deleteApplicationInputProcessingConfiguration(request))
  def addApplicationCloudWatchLoggingOption(
      request: AddApplicationCloudWatchLoggingOptionRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationCloudWatchLoggingOption(request))
  def updateApplicationMaintenanceConfiguration(
      request: UpdateApplicationMaintenanceConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplicationMaintenanceConfiguration(request))
  def deleteApplicationVpcConfiguration(
      request: DeleteApplicationVpcConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationVpcConfiguration(request))
  def addApplicationVpcConfiguration(
      request: AddApplicationVpcConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationVpcConfiguration(request))
  def addApplicationOutput(request: AddApplicationOutputRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationOutput(request))
  def startApplication(request: StartApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startApplication(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteApplicationCloudWatchLoggingOption(
      request: DeleteApplicationCloudWatchLoggingOptionRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationCloudWatchLoggingOption(request))
  def describeApplicationVersion(
      request: DescribeApplicationVersionRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeApplicationVersion(request))
  def addApplicationInputProcessingConfiguration(
      request: AddApplicationInputProcessingConfigurationRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationInputProcessingConfiguration(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def addApplicationInput(request: AddApplicationInputRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addApplicationInput(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(request: ListApplicationsRequest): ZStream[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(request: ListApplicationsRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def listApplicationSnapshots(
      request: ListApplicationSnapshotsRequest
  ): ZStream[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationSnapshots(request))
  def listApplicationSnapshotsPaginated(
      request: ListApplicationSnapshotsRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationSnapshotsPaginated(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def listApplicationVersions(request: ListApplicationVersionsRequest): ZStream[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplicationVersions(request))
  def listApplicationVersionsPaginated(
      request: ListApplicationVersionsRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationVersionsPaginated(request))
  def deleteApplicationReferenceDataSource(
      request: DeleteApplicationReferenceDataSourceRequest
  ): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteApplicationReferenceDataSource(request))
  def stopApplication(request: StopApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopApplication(request))
  def rollbackApplication(request: RollbackApplicationRequest): ZIO[
    zio.aws.kinesisanalyticsv2.KinesisAnalyticsV2,
    AwsError,
    zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rollbackApplication(request))
}
