package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EnvironmentPropertyUpdates(
    propertyGroups: Iterable[zio.aws.kinesisanalyticsv2.model.PropertyGroup]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates = {
    import EnvironmentPropertyUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
      .builder()
      .propertyGroups(propertyGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
      .wrap(buildAwsValue())
}
object EnvironmentPropertyUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates =
      zio.aws.kinesisanalyticsv2.model
        .EnvironmentPropertyUpdates(propertyGroups.map { item =>
          item.asEditable
        })
    def propertyGroups
        : List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly]
    def getPropertyGroups: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly
    ]] = ZIO.succeed(propertyGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
  ) extends zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly {
    override val propertyGroups
        : List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly] = impl
      .propertyGroups()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.PropertyGroup.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
  ): zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly =
    new Wrapper(impl)
}
