package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeApplicationSnapshotResponse(
    snapshotDetails: zio.aws.kinesisanalyticsv2.model.SnapshotDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse = {
    import DescribeApplicationSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
      .builder()
      .snapshotDetails(snapshotDetails.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse =
      zio.aws.kinesisanalyticsv2.model
        .DescribeApplicationSnapshotResponse(snapshotDetails.asEditable)
    def snapshotDetails
        : zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
    def getSnapshotDetails: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
    ] = ZIO.succeed(snapshotDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly {
    override val snapshotDetails
        : zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.SnapshotDetails
        .wrap(impl.snapshotDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
