package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{ZipFileContent, TextContent}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CodeContent(
    textContent: Optional[TextContent] = Optional.Absent,
    zipFileContent: Optional[ZipFileContent] = Optional.Absent,
    s3ContentLocation: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent = {
    import CodeContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent
      .builder()
      .optionallyWith(
        textContent.map(value => TextContent.unwrap(value): java.lang.String)
      )(_.textContent)
      .optionallyWith(
        zipFileContent.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.zipFileContent)
      .optionallyWith(s3ContentLocation.map(value => value.buildAwsValue()))(
        _.s3ContentLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CodeContent.wrap(buildAwsValue())
}
object CodeContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CodeContent =
      zio.aws.kinesisanalyticsv2.model.CodeContent(
        textContent.map(value => value),
        zipFileContent.map(value => value),
        s3ContentLocation.map(value => value.asEditable)
      )
    def textContent: Optional[TextContent]
    def zipFileContent: Optional[ZipFileContent]
    def s3ContentLocation
        : Optional[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly]
    def getTextContent: ZIO[Any, AwsError, TextContent] =
      AwsError.unwrapOptionField("textContent", textContent)
    def getZipFileContent: ZIO[Any, AwsError, ZipFileContent] =
      AwsError.unwrapOptionField("zipFileContent", zipFileContent)
    def getS3ContentLocation: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = AwsError.unwrapOptionField("s3ContentLocation", s3ContentLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent
  ) extends zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly {
    override val textContent: Optional[TextContent] = zio.aws.core.internal
      .optionalFromNullable(impl.textContent())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.TextContent(value)
      )
    override val zipFileContent: Optional[ZipFileContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zipFileContent())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ZipFileContent(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val s3ContentLocation: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ContentLocation())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ContentLocation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent
  ): zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly = new Wrapper(impl)
}
