package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonitoringConfigurationUpdate(
    configurationTypeUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = Optional.Absent,
    metricsLevelUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.MetricsLevel
    ] = Optional.Absent,
    logLevelUpdate: Optional[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate = {
    import MonitoringConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
      .builder()
      .optionallyWith(configurationTypeUpdate.map(value => value.unwrap))(
        _.configurationTypeUpdate
      )
      .optionallyWith(metricsLevelUpdate.map(value => value.unwrap))(
        _.metricsLevelUpdate
      )
      .optionallyWith(logLevelUpdate.map(value => value.unwrap))(
        _.logLevelUpdate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
      .wrap(buildAwsValue())
}
object MonitoringConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate(
        configurationTypeUpdate.map(value => value),
        metricsLevelUpdate.map(value => value),
        logLevelUpdate.map(value => value)
      )
    def configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def metricsLevelUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.MetricsLevel]
    def logLevelUpdate: Optional[zio.aws.kinesisanalyticsv2.model.LogLevel]
    def getConfigurationTypeUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField(
      "configurationTypeUpdate",
      configurationTypeUpdate
    )
    def getMetricsLevelUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      AwsError.unwrapOptionField("metricsLevelUpdate", metricsLevelUpdate)
    def getLogLevelUpdate
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      AwsError.unwrapOptionField("logLevelUpdate", logLevelUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly {
    override val configurationTypeUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationTypeUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
        )
    override val metricsLevelUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsLevelUpdate())
        .map(value => zio.aws.kinesisanalyticsv2.model.MetricsLevel.wrap(value))
    override val logLevelUpdate
        : Optional[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevelUpdate())
        .map(value => zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
